/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import twitter4j.Trend;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.http.Response;
import twitter4j.org.json.JSONArray;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trends
extends TwitterResponse
implements Comparable<Trends> {
    private Date asOf;
    private Date trendAt;
    private Trend[] trends;
    private static final long serialVersionUID = -7151479143843312309L;

    @Override
    public int compareTo(Trends that) {
        return this.trendAt.compareTo(that.trendAt);
    }

    Trends(Response res, Date asOf, Date trendAt, Trend[] trends) throws TwitterException {
        super(res);
        this.asOf = asOf;
        this.trendAt = trendAt;
        this.trends = trends;
    }

    static List<Trends> constructTrendsList(Response res) throws TwitterException {
        JSONObject json = res.asJSONObject();
        try {
            Date asOf = Trends.parseDate(json.getString("as_of"));
            JSONObject trendsJson = json.getJSONObject("trends");
            ArrayList<Trends> trends = new ArrayList<Trends>(trendsJson.length());
            Iterator ite = trendsJson.keys();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                JSONArray array = trendsJson.getJSONArray(key);
                Trend[] trendsArray = Trends.jsonArrayToTrendArray(array);
                if (key.length() == 19) {
                    trends.add(new Trends(res, asOf, Trends.parseDate(key, "yyyy-MM-dd HH:mm:ss"), trendsArray));
                    continue;
                }
                if (key.length() == 16) {
                    trends.add(new Trends(res, asOf, Trends.parseDate(key, "yyyy-MM-dd HH:mm"), trendsArray));
                    continue;
                }
                if (key.length() != 10) continue;
                trends.add(new Trends(res, asOf, Trends.parseDate(key, "yyyy-MM-dd"), trendsArray));
            }
            Collections.sort(trends);
            return trends;
        }
        catch (JSONException jsone) {
            throw new TwitterException(String.valueOf(jsone.getMessage()) + ":" + res.asString(), jsone);
        }
    }

    static Trends constructTrends(Response res) throws TwitterException {
        JSONObject json = res.asJSONObject();
        try {
            Date asOf = Trends.parseDate(json.getString("as_of"));
            JSONArray array = json.getJSONArray("trends");
            Trend[] trendsArray = Trends.jsonArrayToTrendArray(array);
            return new Trends(res, asOf, asOf, trendsArray);
        }
        catch (JSONException jsone) {
            throw new TwitterException(String.valueOf(jsone.getMessage()) + ":" + res.asString(), jsone);
        }
    }

    private static Date parseDate(String asOfStr) throws TwitterException {
        Date parsed = asOfStr.length() == 10 ? new Date(Long.parseLong(asOfStr) * 1000L) : TwitterResponse.parseDate(asOfStr, "EEE, d MMM yyyy HH:mm:ss z");
        return parsed;
    }

    private static Trend[] jsonArrayToTrendArray(JSONArray array) throws JSONException {
        Trend[] trends = new Trend[array.length()];
        int i = 0;
        while (i < array.length()) {
            JSONObject trend = array.getJSONObject(i);
            trends[i] = new Trend(trend);
            ++i;
        }
        return trends;
    }

    public Trend[] getTrends() {
        return this.trends;
    }

    public Date getAsOf() {
        return this.asOf;
    }

    public Date getTrendAt() {
        return this.trendAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trends)) {
            return false;
        }
        Trends trends1 = (Trends)o;
        if (this.asOf != null ? !this.asOf.equals(trends1.asOf) : trends1.asOf != null) {
            return false;
        }
        if (this.trendAt != null ? !this.trendAt.equals(trends1.trendAt) : trends1.trendAt != null) {
            return false;
        }
        return Arrays.equals(this.trends, trends1.trends);
    }

    public int hashCode() {
        int result = this.asOf != null ? this.asOf.hashCode() : 0;
        result = 31 * result + (this.trendAt != null ? this.trendAt.hashCode() : 0);
        result = 31 * result + (this.trends != null ? Arrays.hashCode(this.trends) : 0);
        return result;
    }

    public String toString() {
        return "Trends{asOf=" + this.asOf + ", trendAt=" + this.trendAt + ", trends=" + (this.trends == null ? null : Arrays.asList(this.trends)) + '}';
    }
}

