/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ascii;

import com.hazelcast.ascii.CommandParser;
import com.hazelcast.ascii.TextCommand;
import com.hazelcast.ascii.TextCommandConstants;
import com.hazelcast.ascii.TextCommandService;
import com.hazelcast.ascii.memcache.DeleteCommandParser;
import com.hazelcast.ascii.memcache.ErrorCommand;
import com.hazelcast.ascii.memcache.GetCommandParser;
import com.hazelcast.ascii.memcache.IncrementCommandParser;
import com.hazelcast.ascii.memcache.SetCommandParser;
import com.hazelcast.ascii.memcache.SimpleCommandParser;
import com.hazelcast.ascii.memcache.TouchCommandParser;
import com.hazelcast.ascii.rest.HttpCommand;
import com.hazelcast.ascii.rest.HttpDeleteCommandParser;
import com.hazelcast.ascii.rest.HttpGetCommandParser;
import com.hazelcast.ascii.rest.HttpPostCommandParser;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.SocketReader;
import com.hazelcast.nio.TcpIpConnection;
import com.hazelcast.nio.ascii.SocketTextWriter;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class SocketTextReader
implements TextCommandConstants,
SocketReader {
    private static final Map<String, CommandParser> mapCommandParsers = new HashMap<String, CommandParser>();
    private ByteBuffer commandLine = ByteBuffer.allocate(500);
    private boolean commandLineRead = false;
    private TextCommand command = null;
    private final TextCommandService textCommandService;
    private final SocketTextWriter socketTextWriter;
    private final TcpIpConnection connection;
    private final boolean restEnabled;
    private final boolean memcacheEnabled;
    private boolean connectionTypeSet = false;
    private long requestIdGen;
    private final ILogger logger;

    public SocketTextReader(TcpIpConnection connection) {
        IOService ioService = connection.getConnectionManager().getIOHandler();
        this.textCommandService = ioService.getTextCommandService();
        this.socketTextWriter = (SocketTextWriter)connection.getWriteHandler().getSocketWriter();
        this.connection = connection;
        this.memcacheEnabled = ioService.isMemcacheEnabled();
        this.restEnabled = ioService.isRestEnabled();
        this.logger = ioService.getLogger(this.getClass().getName());
    }

    public void sendResponse(TextCommand command) {
        this.socketTextWriter.enqueue(command);
    }

    @Override
    public void read(ByteBuffer inBuffer) {
        while (inBuffer.hasRemaining()) {
            this.doRead(inBuffer);
        }
    }

    private void doRead(ByteBuffer bb) {
        while (!this.commandLineRead && bb.hasRemaining()) {
            byte b = bb.get();
            char c = (char)b;
            if (c == '\n') {
                this.commandLineRead = true;
                continue;
            }
            if (c == '\r') continue;
            this.commandLine.put(b);
        }
        if (this.commandLineRead) {
            if (this.command == null) {
                this.processCmd(SocketTextReader.toStringAndClear(this.commandLine));
            }
            if (this.command != null) {
                boolean complete = this.command.readFrom(bb);
                if (complete) {
                    this.publishRequest(this.command);
                    this.reset();
                }
            } else {
                this.reset();
            }
        }
    }

    void reset() {
        this.command = null;
        this.commandLine.clear();
        this.commandLineRead = false;
    }

    public static String toStringAndClear(ByteBuffer bb) {
        if (bb == null) {
            return "";
        }
        String result = null;
        result = bb.position() == 0 ? "" : new String(bb.array(), 0, bb.position());
        bb.clear();
        return result;
    }

    public void publishRequest(TextCommand command) {
        long l;
        if (!this.connectionTypeSet) {
            if (command instanceof HttpCommand) {
                if (!this.restEnabled) {
                    this.connection.close();
                }
                this.connection.setType(ConnectionType.REST_CLIENT);
            } else {
                if (!this.memcacheEnabled) {
                    this.connection.close();
                }
                this.connection.setType(ConnectionType.MEMCACHE_CLIENT);
            }
            this.connectionTypeSet = true;
        }
        if (command.shouldReply()) {
            long l2 = this.requestIdGen;
            l = l2;
            this.requestIdGen = l2 + 1L;
        } else {
            l = -1L;
        }
        long requestId = l;
        command.init(this, requestId);
        this.textCommandService.processRequest(command);
    }

    void processCmd(String cmd) {
        try {
            int space = cmd.indexOf(32);
            String operation = space == -1 ? cmd : cmd.substring(0, space);
            CommandParser commandParser = mapCommandParsers.get(operation);
            this.command = commandParser != null ? commandParser.parser(this, cmd, space) : new ErrorCommand(TextCommandConstants.TextCommandType.UNKNOWN);
        }
        catch (Throwable t) {
            this.logger.finest(t);
            this.command = new ErrorCommand(TextCommandConstants.TextCommandType.ERROR_CLIENT, "Invalid command : " + cmd);
        }
    }

    public SocketTextWriter getSocketTextWriter() {
        return this.socketTextWriter;
    }

    public void closeConnection() {
        this.connection.close();
    }

    static {
        mapCommandParsers.put("get", new GetCommandParser());
        mapCommandParsers.put("gets", new GetCommandParser());
        mapCommandParsers.put("set", new SetCommandParser(TextCommandConstants.TextCommandType.SET));
        mapCommandParsers.put("add", new SetCommandParser(TextCommandConstants.TextCommandType.ADD));
        mapCommandParsers.put("replace", new SetCommandParser(TextCommandConstants.TextCommandType.REPLACE));
        mapCommandParsers.put("append", new SetCommandParser(TextCommandConstants.TextCommandType.APPEND));
        mapCommandParsers.put("prepend", new SetCommandParser(TextCommandConstants.TextCommandType.PREPEND));
        mapCommandParsers.put("touch", new TouchCommandParser(TextCommandConstants.TextCommandType.TOUCH));
        mapCommandParsers.put("incr", new IncrementCommandParser(TextCommandConstants.TextCommandType.INCREMENT));
        mapCommandParsers.put("decr", new IncrementCommandParser(TextCommandConstants.TextCommandType.DECREMENT));
        mapCommandParsers.put("delete", new DeleteCommandParser());
        mapCommandParsers.put("quit", new SimpleCommandParser(TextCommandConstants.TextCommandType.QUIT));
        mapCommandParsers.put("stats", new SimpleCommandParser(TextCommandConstants.TextCommandType.STATS));
        mapCommandParsers.put("version", new SimpleCommandParser(TextCommandConstants.TextCommandType.VERSION));
        mapCommandParsers.put("GET", new HttpGetCommandParser());
        mapCommandParsers.put("POST", new HttpPostCommandParser());
        mapCommandParsers.put("PUT", new HttpPostCommandParser());
        mapCommandParsers.put("DELETE", new HttpDeleteCommandParser());
    }
}

