/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.javasimon.StopwatchSample;
import org.javasimon.examples.ExampleUtils;
import org.javasimon.examples.MultithreadedTester;
import org.javasimon.utils.BenchmarkUtils;
import org.javasimon.utils.GoogleChartImageGenerator;

public final class MultithreadedStopwatchLoad
extends Thread {
    public static final int TOTAL_TASK_RUNS = 10000000;

    private MultithreadedStopwatchLoad() {
    }

    public static void main(String[] args) throws InterruptedException {
        ExampleUtils.fillManagerWithSimons(100000);
        final ExecutorService executorService = Executors.newFixedThreadPool(1000);
        StopwatchSample[] results = BenchmarkUtils.run((int)1, (int)2, (BenchmarkUtils.Task[])new BenchmarkUtils.Task[]{new BenchmarkUtils.Task("1"){

            public void perform() throws Exception {
                new MultithreadedTester(10000000, 1, executorService).execute();
            }
        }, new BenchmarkUtils.Task("2"){

            public void perform() throws Exception {
                new MultithreadedTester(10000000, 2, executorService).execute();
            }
        }, new BenchmarkUtils.Task("10"){

            public void perform() throws Exception {
                new MultithreadedTester(10000000, 10, executorService).execute();
            }
        }, new BenchmarkUtils.Task("100"){

            public void perform() throws Exception {
                new MultithreadedTester(10000000, 100, executorService).execute();
            }
        }, new BenchmarkUtils.Task("1000"){

            public void perform() throws Exception {
                new MultithreadedTester(10000000, 1000, executorService).execute();
            }
        }, new BenchmarkUtils.Task("1000thr"){

            public void perform() throws Exception {
                new MultithreadedTester(10000000, 1000, null).execute();
            }
        }});
        executorService.shutdown();
        System.out.println("\nGoogle Chart avg:\n" + GoogleChartImageGenerator.barChart((StopwatchSample[])results, (String)"Multithreaded test", (double)1000000.0, (String)"ms", (boolean)false));
    }
}

