/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.datastore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.datastore.AbstractRefreshableDataStore;
import net.sf.uadetector.datastore.AbstractUpdateOperation;
import net.sf.uadetector.datastore.DataStore;
import net.sf.uadetector.exception.CanNotOpenStreamException;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.util.Closeables;
import net.sf.uadetector.internal.util.FileUtil;
import net.sf.uadetector.internal.util.UrlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UpdateOperationWithCacheFileTask
extends AbstractUpdateOperation {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateOperationWithCacheFileTask.class);
    private static final String MSG_CACHE_FILE_ISSUES = "Issues occured during reading of or writing to the cache file: %s";
    private static final String MSG_SAME_RESOURCES = "The passed URL and file resources are the same. An update was not performed.";
    private final File cacheFile;
    private final AbstractRefreshableDataStore store;

    protected static File createTemporaryFile(@Nonnull File file) {
        Check.notNull((Object)file, (String)"file");
        File tempFile = new File(file.getParent(), file.getName() + ".temp");
        UpdateOperationWithCacheFileTask.deleteFile(tempFile);
        return tempFile;
    }

    protected static void deleteFile(@Nonnull File file) {
        Check.notNull((Object)file, (String)"file");
        Check.stateIsTrue((!file.exists() || file.delete() ? 1 : 0) != 0, (String)"Cannot delete file '%s'.", (Object[])new Object[]{file.getPath()});
    }

    private static boolean isEmpty(@Nonnull File file, @Nonnull Charset charset) {
        try {
            return FileUtil.isEmpty(file, charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("The given file could not be read.");
        }
    }

    protected static boolean isNewerData(@Nonnull Data older, @Nonnull Data newer) {
        return newer.getVersion().compareTo(older.getVersion()) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void readAndSave(@Nonnull File file, @Nonnull DataStore store) throws IOException {
        Check.notNull((Object)file, (String)"file");
        Check.notNull((Object)store, (String)"store");
        URL url = store.getDataUrl();
        Charset charset = store.getCharset();
        boolean isEqual = url.toExternalForm().equals(UrlUtil.toUrl(file).toExternalForm());
        if (!isEqual) {
            String data = UrlUtil.read(url, charset);
            if (Data.EMPTY.equals(store.getDataReader().read(data))) {
                throw new IllegalStateException("The read in content can not be transformed to an instance of 'Data'.");
            }
            File tempFile = UpdateOperationWithCacheFileTask.createTemporaryFile(file);
            FileOutputStream outputStream = null;
            boolean threw = true;
            try {
                outputStream = new FileOutputStream(tempFile);
                outputStream.write(data.getBytes(charset));
                UpdateOperationWithCacheFileTask.deleteFile(file);
                threw = false;
            }
            finally {
                Closeables.close(outputStream, threw);
            }
            UpdateOperationWithCacheFileTask.renameFile(tempFile, file);
        } else {
            LOG.debug(MSG_SAME_RESOURCES);
        }
    }

    protected static void renameFile(@Nonnull File from, @Nonnull File to) {
        Check.notNull((Object)from, (String)"from");
        Check.stateIsTrue((boolean)from.exists(), (String)"Argument 'from' must not be an existing file.");
        Check.notNull((Object)to, (String)"to");
        Check.stateIsTrue((boolean)from.renameTo(to), (String)"Renaming file from '%s' to '%s' failed.", (Object[])new Object[]{from.getAbsolutePath(), to.getAbsolutePath()});
    }

    public UpdateOperationWithCacheFileTask(@Nonnull AbstractRefreshableDataStore dataStore, @Nonnull File cacheFile) {
        super(dataStore);
        Check.notNull((Object)dataStore, (String)"dataStore");
        Check.notNull((Object)cacheFile, (String)"cacheFile");
        this.store = dataStore;
        this.cacheFile = cacheFile;
    }

    @Override
    public void call() {
        this.readDataIfNewerAvailable();
    }

    private boolean isCacheFileEmpty() {
        return UpdateOperationWithCacheFileTask.isEmpty(this.cacheFile, this.store.getCharset());
    }

    private void readDataIfNewerAvailable() {
        try {
            if (this.isUpdateAvailable() || this.isCacheFileEmpty()) {
                UpdateOperationWithCacheFileTask.readAndSave(this.cacheFile, this.store);
                this.store.setData(this.store.getDataReader().read(this.cacheFile.toURI().toURL(), this.store.getCharset()));
            }
        }
        catch (CanNotOpenStreamException e) {
            LOG.warn(String.format("The data can not be read from the specified URL: %s", e.getLocalizedMessage()));
            this.readFallbackData();
        }
        catch (RuntimeException e) {
            LOG.warn("The read content is faulty and can not be processed correctly.", (Throwable)e);
            this.readFallbackData();
        }
        catch (IOException e) {
            LOG.warn(String.format(MSG_CACHE_FILE_ISSUES, e.getLocalizedMessage()), (Throwable)e);
            this.readFallbackData();
        }
    }

    private void readFallbackData() {
        LOG.info("Reading fallback data...");
        try {
            if (this.isCacheFileEmpty()) {
                UpdateOperationWithCacheFileTask.readAndSave(this.cacheFile, this.store.getFallback());
                Data data = this.store.getDataReader().read(this.cacheFile.toURI().toURL(), this.store.getCharset());
                if (UpdateOperationWithCacheFileTask.isNewerData(this.store.getData(), data)) {
                    this.store.setData(data);
                }
            }
        }
        catch (CanNotOpenStreamException e) {
            LOG.warn(String.format("The data can not be read from the specified URL: %s", e.getLocalizedMessage()));
        }
        catch (RuntimeException e) {
            LOG.warn("The read content is faulty and can not be processed correctly.", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn(String.format(MSG_CACHE_FILE_ISSUES, e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

