/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.javaee;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.callback.Callback;
import org.javasimon.callback.CallbackSkeleton;
import org.javasimon.javaee.SimonServletFilterUtils;
import org.javasimon.javaee.reqreporter.RequestReporter;
import org.javasimon.source.StopwatchTemplate;
import org.javasimon.utils.Replacer;
import org.javasimon.utils.SimonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimonServletFilter
implements Filter {
    public static final String INIT_PARAM_PREFIX = "prefix";
    public static final String INIT_PARAM_REPORT_THRESHOLD_MS = "report-threshold-ms";
    public static final String INIT_PARAM_SIMON_CONSOLE_PATH = "console-path";
    public static final String INIT_PARAM_STOPWATCH_SOURCE_CLASS = "stopwatch-source-class";
    public static final String INIT_PARAM_STOPWATCH_SOURCE_CACHE = "stopwatch-source-cache";
    public static final String INIT_PARAM_REQUEST_REPORTER_CLASS = "request-reporter-class";
    private static Replacer FINAL_SLASH_REMOVE = new Replacer("/*$", "", new Replacer.Modificator[0]);
    private static Replacer SLASH_TRIM = new Replacer("^/*(.*?)/*$", "$1", new Replacer.Modificator[0]);
    protected Long reportThresholdNanos;
    protected String printTreePath;
    protected String consolePath;
    private Manager manager = SimonManager.manager();
    private final ThreadLocal<List<Split>> splitsThreadLocal = new ThreadLocal();
    private SplitSaverCallback splitSaverCallback;
    private StopwatchTemplate<HttpServletRequest> stopwatchTemplate;
    private RequestReporter requestReporter;

    public final void init(FilterConfig filterConfig) {
        String consolePath;
        this.pickUpSharedManagerIfExists(filterConfig);
        this.stopwatchTemplate = new StopwatchTemplate(SimonServletFilterUtils.initStopwatchSource(filterConfig, this.manager));
        this.requestReporter = SimonServletFilterUtils.initRequestReporter(filterConfig);
        this.requestReporter.setSimonServletFilter(this);
        String reportTreshold = filterConfig.getInitParameter(INIT_PARAM_REPORT_THRESHOLD_MS);
        if (reportTreshold != null) {
            try {
                this.reportThresholdNanos = Long.parseLong(reportTreshold) * 1000000L;
                this.splitSaverCallback = new SplitSaverCallback();
                this.manager.callback().addCallback((Callback)this.splitSaverCallback);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((consolePath = filterConfig.getInitParameter(INIT_PARAM_SIMON_CONSOLE_PATH)) != null) {
            this.printTreePath = FINAL_SLASH_REMOVE.process(consolePath);
            this.consolePath = this.printTreePath + "/";
        }
    }

    private void pickUpSharedManagerIfExists(FilterConfig filterConfig) {
        Object managerObject = filterConfig.getServletContext().getAttribute("manager-servlet-ctx-attribute");
        if (managerObject != null && managerObject instanceof Manager) {
            this.manager = (Manager)managerObject;
        }
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String localPath = request.getRequestURI().substring(request.getContextPath().length());
        if (this.consolePath != null && (localPath.equals(this.printTreePath) || localPath.startsWith(this.consolePath))) {
            this.consolePage(request, response, localPath);
            return;
        }
        this.doFilterWithMonitoring(filterChain, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilterWithMonitoring(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Split split = this.stopwatchTemplate.start((Object)request);
        if (split != null && this.reportThresholdNanos != null) {
            this.splitsThreadLocal.set(new ArrayList());
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (split != null) {
                long splitNanoTime = split.stop().runningFor();
                if (this.reportThresholdNanos != null) {
                    List<Split> splits = this.splitsThreadLocal.get();
                    this.splitsThreadLocal.remove();
                    if (this.shouldBeReported(request, splitNanoTime, splits)) {
                        this.requestReporter.reportRequest(request, split, splits);
                    }
                }
            }
        }
    }

    protected boolean shouldBeReported(HttpServletRequest request, long requestNanoTime, List<Split> splits) {
        return requestNanoTime > this.getThreshold(request);
    }

    protected long getThreshold(HttpServletRequest request) {
        return this.reportThresholdNanos;
    }

    private void consolePage(HttpServletRequest request, HttpServletResponse response, String localPath) throws IOException {
        response.setContentType("text/plain");
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        if (localPath.equals(this.printTreePath)) {
            this.printSimonTree((ServletResponse)response);
            return;
        }
        String subcommand = SLASH_TRIM.process(localPath.substring(this.consolePath.length()));
        if (subcommand.isEmpty()) {
            this.printSimonTree((ServletResponse)response);
        } else if (subcommand.equalsIgnoreCase("clear")) {
            this.manager.clear();
            response.getOutputStream().println("Simon Manager was cleared");
        } else if (subcommand.equalsIgnoreCase("help")) {
            this.simonHelp((ServletResponse)response);
        } else {
            response.getOutputStream().println("Invalid command\n");
            this.simonHelp((ServletResponse)response);
        }
    }

    private void simonHelp(ServletResponse response) throws IOException {
        response.getOutputStream().println("Simon Console help - available commands:");
        response.getOutputStream().println("- clear - clears the manager (removes all Simons)");
        response.getOutputStream().println("- help - shows this help");
    }

    private void printSimonTree(ServletResponse response) throws IOException {
        response.getOutputStream().println(SimonUtils.simonTreeString((Simon)this.manager.getRootSimon()));
    }

    public Manager getManager() {
        return this.manager;
    }

    public void destroy() {
        if (this.splitSaverCallback != null) {
            this.manager.callback().removeCallback((Callback)this.splitSaverCallback);
        }
    }

    private class SplitSaverCallback
    extends CallbackSkeleton {
        private SplitSaverCallback() {
        }

        public void onStopwatchStart(Split split) {
            List splits = (List)SimonServletFilter.this.splitsThreadLocal.get();
            if (splits != null) {
                splits.add(split);
            }
        }
    }
}

