/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ValidationUtil {
    private ValidationUtil() {
    }

    public static <T> T checkNotNull(T argument, String message) {
        if (argument == null) {
            throw new NullPointerException(message);
        }
        return argument;
    }

    public static String hasText(String argument, String argName) {
        ValidationUtil.isNotNull(argument, argName);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(String.format("argument '%s' can't be an empty string", argName));
        }
        return argument;
    }

    public static <E> E isNotNull(E argument, String argName) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("argument '%s' can't be null", argName));
        }
        return argument;
    }

    public static void isNotNegative(long value, String argumentName) {
        if (value < 0L) {
            throw new IllegalArgumentException(argumentName + " cannot be negative!");
        }
    }

    public static void shouldBePositive(long value, String argumentName) {
        if (value <= 0L) {
            throw new IllegalArgumentException(argumentName + " should be positive!");
        }
    }

    public static <E> E checkInstanceOf(Class type, E object, String argumentName) {
        ValidationUtil.isNotNull(type, "type");
        if (!type.isInstance(object)) {
            throw new IllegalArgumentException(argumentName + " should be an instance of " + type + ", but found " + object);
        }
        return object;
    }

    public static <E> E checkNotInstanceOf(Class type, E object, String argumentName) {
        ValidationUtil.isNotNull(type, "type");
        if (type.isInstance(object)) {
            throw new IllegalArgumentException(argumentName + " can not be an instance of " + type);
        }
        return object;
    }

    public static void checkFalse(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> Iterator<T> checkHasNext(Iterator<T> iterator, String message) throws NoSuchElementException {
        if (!iterator.hasNext()) {
            throw new NoSuchElementException(message);
        }
        return iterator;
    }

    public static void checkState(boolean condition, String message) throws IllegalStateException {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

