/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.impl.BaseMigrationOperation;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.partition.impl.MigrationOperation;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

public final class MigrationRequestOperation
extends BaseMigrationOperation {
    private static final int TRY_PAUSE_MILLIS = 1000;
    private boolean returnResponse = true;

    public MigrationRequestOperation() {
    }

    public MigrationRequestOperation(MigrationInfo migrationInfo) {
        super(migrationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NodeEngine nodeEngine = this.getNodeEngine();
        this.verifyGoodMaster(nodeEngine);
        Address source = this.migrationInfo.getSource();
        Address destination = this.migrationInfo.getDestination();
        this.verifyExistingTarget(nodeEngine, destination);
        if (destination.equals(source)) {
            this.getLogger().warning("Source and destination addresses are the same! => " + this.toString());
            this.success = false;
            return;
        }
        this.verifyNotThisNode(nodeEngine, source);
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        InternalPartitionImpl partition = partitionService.getPartition(this.migrationInfo.getPartitionId());
        Address owner = partition.getOwnerOrNull();
        this.verifyOwnerExists(owner);
        if (!this.migrationInfo.startProcessing()) {
            this.getLogger().warning("Migration is cancelled -> " + this.migrationInfo);
            this.success = false;
            return;
        }
        try {
            this.verifyOwner(source, partition, owner);
            partitionService.addActiveMigration(this.migrationInfo);
            Collection<Operation> tasks = this.prepareMigrationTasks();
            if (tasks.size() > 0) {
                long[] replicaVersions = partitionService.getPartitionReplicaVersions(this.migrationInfo.getPartitionId());
                this.invokeMigrationOperation(destination, replicaVersions, tasks);
                this.returnResponse = false;
            } else {
                this.success = true;
            }
        }
        catch (Throwable e) {
            this.logThrowable(e);
            this.success = false;
        }
        finally {
            this.migrationInfo.doneProcessing();
        }
    }

    private void logThrowable(Throwable t) {
        Throwable throwableToLog = t;
        if (throwableToLog instanceof ExecutionException) {
            throwableToLog = throwableToLog.getCause() != null ? throwableToLog.getCause() : throwableToLog;
        }
        Level level = this.getLogLevel(throwableToLog);
        this.getLogger().log(level, throwableToLog.getMessage(), throwableToLog);
    }

    private Level getLogLevel(Throwable e) {
        return e instanceof MemberLeftException || e instanceof InterruptedException || !this.getNodeEngine().isActive() ? Level.INFO : Level.WARNING;
    }

    private void verifyNotThisNode(NodeEngine nodeEngine, Address source) {
        if (source == null || !source.equals(nodeEngine.getThisAddress())) {
            throw new RetryableHazelcastException("Source of migration is not this node! => " + this.toString());
        }
    }

    private void verifyOwnerExists(Address owner) {
        if (owner == null) {
            throw new RetryableHazelcastException("Cannot migrate at the moment! Owner of the partition is null => " + this.migrationInfo);
        }
    }

    private void verifyOwner(Address source, InternalPartition partition, Address owner) {
        if (!source.equals(owner)) {
            throw new HazelcastException("Cannot migrate! This node is not owner of the partition => " + this.migrationInfo + " -> partitionId=" + partition.getPartitionId() + " , " + partition);
        }
    }

    private void invokeMigrationOperation(Address destination, long[] replicaVersions, Collection<Operation> tasks) throws IOException {
        MigrationOperation operation = new MigrationOperation(this.migrationInfo, replicaVersions, tasks);
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, destination).setCallback(new MigrationCallback(this.migrationInfo, this.getResponseHandler())).setResultDeserialized(true).setCallTimeout(partitionService.getPartitionMigrationTimeout()).setTryPauseMillis(1000L).setReplicaIndex(this.getReplicaIndex()).invoke();
    }

    private void verifyGoodMaster(NodeEngine nodeEngine) {
        Address masterAddress = nodeEngine.getMasterAddress();
        if (!masterAddress.equals(this.migrationInfo.getMaster())) {
            throw new RetryableHazelcastException("Migration initiator is not master node! => " + this.toString());
        }
        if (!masterAddress.equals(this.getCallerAddress())) {
            throw new RetryableHazelcastException("Caller is not master node! => " + this.toString());
        }
    }

    private void verifyExistingTarget(NodeEngine nodeEngine, Address destination) {
        MemberImpl target = nodeEngine.getClusterService().getMember(destination);
        if (target == null) {
            throw new TargetNotMemberException("Destination of migration could not be found! => " + this.toString());
        }
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        if (throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public boolean returnsResponse() {
        return this.returnResponse;
    }

    private Collection<Operation> prepareMigrationTasks() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionReplicationEvent replicationEvent = new PartitionReplicationEvent(this.migrationInfo.getPartitionId(), 0);
        PartitionMigrationEvent migrationEvent = new PartitionMigrationEvent(MigrationEndpoint.SOURCE, this.migrationInfo.getPartitionId());
        LinkedList<Operation> tasks = new LinkedList<Operation>();
        for (ServiceInfo serviceInfo : nodeEngine.getServiceInfos(MigrationAwareService.class)) {
            MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
            service.beforeMigration(migrationEvent);
            Operation op = service.prepareReplicationOperation(replicationEvent);
            if (op == null) continue;
            op.setServiceName(serviceInfo.getName());
            tasks.add(op);
        }
        return tasks;
    }

    private static final class MigrationCallback
    implements Callback<Object> {
        final MigrationInfo migrationInfo;
        final ResponseHandler responseHandler;

        private MigrationCallback(MigrationInfo migrationInfo, ResponseHandler responseHandler) {
            this.migrationInfo = migrationInfo;
            this.responseHandler = responseHandler;
        }

        @Override
        public void notify(Object result) {
            this.migrationInfo.doneProcessing();
            this.responseHandler.sendResponse(result);
        }
    }
}

