/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.wan;

import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.impl.wan.WanReplicationEndpoint;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

public class WanNoDelayReplication
implements Runnable,
WanReplicationEndpoint {
    private Node node;
    private ILogger logger;
    private String groupName;
    private String password;
    private final LinkedBlockingQueue<String> addressQueue = new LinkedBlockingQueue();
    private final LinkedList<RecordUpdate> failureQ = new LinkedList();
    private final BlockingQueue<RecordUpdate> q = new ArrayBlockingQueue<RecordUpdate>(100000);
    private volatile boolean running = true;

    @Override
    public void init(Node node, String groupName, String password, String ... targets) {
        this.node = node;
        this.logger = node.getLogger(WanNoDelayReplication.class.getName());
        this.groupName = groupName;
        this.password = password;
        this.addressQueue.addAll(Arrays.asList(targets));
        node.executorManager.executeNow(this);
    }

    @Override
    public void recordUpdated(Record record) {
        DataRecordEntry dataRecordEntry = new DataRecordEntry(record);
        RecordUpdate ru = new RecordUpdate(dataRecordEntry, record.getName());
        if (!this.q.offer(ru)) {
            this.q.poll();
            this.q.offer(ru);
        }
    }

    @Override
    public void shutdown() {
        this.running = false;
    }

    @Override
    public void run() {
        Connection conn = null;
        while (this.running) {
            try {
                boolean authorized;
                RecordUpdate ru;
                RecordUpdate recordUpdate = ru = this.failureQ.size() > 0 ? this.failureQ.removeFirst() : this.q.take();
                if (conn == null && (conn = this.getConnection()) != null && !(authorized = this.node.clusterManager.checkAuthorization(this.groupName, this.password, conn.getEndPoint()))) {
                    conn.close();
                    conn = null;
                    if (this.logger != null) {
                        this.logger.log(Level.SEVERE, "Invalid groupName or groupPassword! ");
                    }
                }
                if (conn != null && conn.live()) {
                    conn.getWriteHandler().enqueueSocketWritable(ru.toNewPacket());
                    continue;
                }
                this.failureQ.addFirst(ru);
                conn = null;
            }
            catch (InterruptedException e) {
                this.running = false;
            }
            catch (Throwable e) {
                if (this.logger != null) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                }
                conn = null;
            }
        }
    }

    /*
     * Exception decompiling
     */
    Connection getConnection() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    class RecordUpdate {
        final DataRecordEntry dataRecordEntry;
        final String name;

        RecordUpdate(DataRecordEntry dataRecordEntry, String name) {
            this.dataRecordEntry = dataRecordEntry;
            this.name = name;
        }

        public Packet toNewPacket() {
            Packet packet = new Packet();
            packet.name = this.name;
            packet.operation = ClusterOperation.CONCURRENT_MAP_ASYNC_MERGE;
            packet.setKey(this.dataRecordEntry.getKeyData());
            packet.setValue(IOUtil.toData(this.dataRecordEntry));
            return packet;
        }
    }
}

