/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;

public final class GeoLocation {
    private final double _latitude;
    private final double _longitude;

    public GeoLocation(double d, double d2) {
        this._latitude = d;
        this._longitude = d2;
    }

    public double getLatitude() {
        return this._latitude;
    }

    public double getLongitude() {
        return this._longitude;
    }

    public boolean isZero() {
        return this._latitude == 0.0 && this._longitude == 0.0;
    }

    @NotNull
    public static String decimalToDegreesMinutesSecondsString(double d) {
        double[] dArray = GeoLocation.decimalToDegreesMinutesSeconds(d);
        return dArray[0] + "\u00b0 " + dArray[1] + "' " + dArray[2] + '\"';
    }

    @NotNull
    public static double[] decimalToDegreesMinutesSeconds(double d) {
        int n = (int)d;
        double d2 = Math.abs(d % 1.0 * 60.0);
        double d3 = d2 % 1.0 * 60.0;
        return new double[]{n, (int)d2, d3};
    }

    @Nullable
    public static Double degreesMinutesSecondsToDecimal(@NotNull Rational rational, @NotNull Rational rational2, @NotNull Rational rational3, boolean bl) {
        double d = Math.abs(rational.doubleValue()) + rational2.doubleValue() / 60.0 + rational3.doubleValue() / 3600.0;
        if (Double.isNaN(d)) {
            return null;
        }
        if (bl) {
            d *= -1.0;
        }
        return d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GeoLocation geoLocation = (GeoLocation)object;
        if (Double.compare(geoLocation._latitude, this._latitude) != 0) {
            return false;
        }
        return Double.compare(geoLocation._longitude, this._longitude) == 0;
    }

    public int hashCode() {
        long l = this._latitude != 0.0 ? Double.doubleToLongBits(this._latitude) : 0L;
        int n = (int)(l ^ l >>> 32);
        l = this._longitude != 0.0 ? Double.doubleToLongBits(this._longitude) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @NotNull
    public String toString() {
        return this._latitude + ", " + this._longitude;
    }

    @NotNull
    public String toDMSString() {
        return GeoLocation.decimalToDegreesMinutesSecondsString(this._latitude) + ", " + GeoLocation.decimalToDegreesMinutesSecondsString(this._longitude);
    }
}

