/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.impl.AbstractJoiner;
import com.hazelcast.impl.MulticastListener;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.SplitBrainHandler;
import com.hazelcast.impl.TcpIpJoiner;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.Clock;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class MulticastJoiner
extends AbstractJoiner {
    private final AtomicInteger currentTryCount = new AtomicInteger(0);
    private final AtomicInteger maxTryCount = new AtomicInteger(this.calculateTryCount());

    public MulticastJoiner(Node node) {
        super(node);
    }

    @Override
    public void doJoin(AtomicBoolean joined) {
        int tryCount = 0;
        long joinStartTime = Clock.currentTimeMillis();
        long maxJoinMillis = this.node.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000;
        while (this.node.isActive() && !joined.get() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
            Address masterAddressNow;
            String msg = "Joining to master node: " + this.node.getMasterAddress();
            this.logger.log(Level.FINEST, msg);
            this.systemLogService.logJoin(msg);
            if (this.targetAddress == null) {
                masterAddressNow = this.findMasterWithMulticast();
            } else {
                masterAddressNow = this.targetAddress;
                this.targetAddress = null;
            }
            this.node.setMasterAddress(masterAddressNow);
            if (masterAddressNow != null) {
                this.systemLogService.logJoin("Setting master address to " + masterAddressNow);
            }
            if (this.node.getMasterAddress() == null || this.node.address.equals(this.node.getMasterAddress())) {
                TcpIpConfig tcpIpConfig = this.config.getNetworkConfig().getJoin().getTcpIpConfig();
                if (tcpIpConfig != null && tcpIpConfig.isEnabled()) {
                    this.doTCP(joined);
                } else {
                    this.node.setAsMaster();
                }
                return;
            }
            if (++tryCount > 49) {
                this.failedJoiningToMaster(true, tryCount);
            }
            if (!this.node.getMasterAddress().equals(this.node.address)) {
                this.connectAndSendJoinRequest(this.node.getMasterAddress());
            } else {
                this.node.setMasterAddress(null);
                tryCount = 0;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void doTCP(AtomicBoolean joined) {
        this.node.setMasterAddress(null);
        this.logger.log(Level.FINEST, "Multicast couldn't find cluster. Trying TCP/IP");
        new TcpIpJoiner(this.node).join(joined);
    }

    @Override
    public void searchForOtherClusters(SplitBrainHandler splitBrainHandler) {
        final LinkedBlockingQueue q = new LinkedBlockingQueue();
        MulticastListener listener = new MulticastListener(){

            @Override
            public void onMessage(Object msg) {
                MulticastJoiner.this.systemLogService.logJoin("MulticastListener onMessage " + msg);
                if (msg != null && msg instanceof JoinInfo) {
                    JoinInfo joinInfo = (JoinInfo)msg;
                    if (MulticastJoiner.this.node.address != null && !MulticastJoiner.this.node.address.equals(joinInfo.address)) {
                        q.offer(msg);
                    }
                }
            }
        };
        this.node.multicastService.addMulticastListener(listener);
        this.node.multicastService.send(this.node.createJoinInfo());
        this.systemLogService.logJoin("Sent multicast join request");
        try {
            JoinInfo joinInfo = (JoinInfo)q.poll(3L, TimeUnit.SECONDS);
            if (joinInfo != null) {
                if (joinInfo.getMemberCount() == 1) {
                    Thread.sleep((long)this.node.groupProperties.WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L * 2L);
                }
                if (this.shouldMerge(joinInfo)) {
                    this.logger.log(Level.WARNING, this.node.address + " is merging [multicast] to " + joinInfo.address);
                    this.targetAddress = joinInfo.address;
                    this.node.clusterManager.sendClusterMergeToOthers(this.targetAddress);
                    splitBrainHandler.restart();
                    return;
                }
            }
        }
        catch (InterruptedException joinInfo) {
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        finally {
            this.node.multicastService.removeMulticastListener(listener);
        }
    }

    private boolean connectAndSendJoinRequest(Address masterAddress) {
        if (masterAddress == null || masterAddress.equals(this.node.address)) {
            throw new IllegalArgumentException();
        }
        Connection conn = this.node.connectionManager.getOrConnect(masterAddress);
        this.logger.log(Level.FINEST, "Master connection " + conn);
        this.systemLogService.logJoin("Master connection " + conn);
        if (conn != null) {
            return this.node.clusterManager.sendJoinRequest(masterAddress, true);
        }
        this.logger.log(Level.INFO, "Connecting to master node: " + masterAddress);
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Address findMasterWithMulticast() {
        try {
            block10: {
                ip = System.getProperty("join.ip");
                if (ip != null) break block10;
                joinInfo = this.node.createJoinInfo();
                if (true) ** GOTO lbl14
                do {
                    joinInfo.setTryCount(this.currentTryCount.get());
                    this.node.multicastService.send(joinInfo);
                    if (this.node.getMasterAddress() == null) {
                        Thread.sleep(10L);
                    } else {
                        var4_4 = this.node.getMasterAddress();
                        return var4_4;
                    }
lbl14:
                    // 2 sources

                    if (!this.node.isActive()) return null;
                } while (this.currentTryCount.incrementAndGet() <= this.maxTryCount.get());
                return null;
            }
            this.logger.log(Level.FINEST, "RETURNING join.ip");
            var4_5 = new Address(ip, this.config.getNetworkConfig().getPort());
            return var4_5;
        }
        catch (Exception e) {
            if (this.logger == null) return null;
            this.logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
        finally {
            this.currentTryCount.set(0);
        }
    }

    private int calculateTryCount() {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        int timeoutSeconds = networkConfig.getJoin().getMulticastConfig().getMulticastTimeoutSeconds();
        int tryCount = timeoutSeconds * 100;
        String host = this.node.address.getHost();
        int lastDigits = 0;
        try {
            lastDigits = Integer.valueOf(host.substring(host.lastIndexOf(".") + 1));
        }
        catch (NumberFormatException e) {
            lastDigits = (int)(512.0 * Math.random());
        }
        return tryCount += (lastDigits %= 100) + (this.node.address.getPort() - networkConfig.getPort()) * timeoutSeconds * 3;
    }

    public void onReceivedJoinInfo(JoinInfo joinInfo) {
        if (joinInfo.getTryCount() > this.currentTryCount.get() + 20) {
            int timeoutSeconds = (this.config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastTimeoutSeconds() + 4) * 100;
            this.maxTryCount.set(timeoutSeconds);
        }
    }
}

