/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.QueryResult;
import com.hazelcast.map.impl.operation.AbstractMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class QueryPartitionOperation
extends AbstractMapOperation
implements PartitionAwareOperation {
    private Predicate predicate;
    private QueryResult result;

    public QueryPartitionOperation(String mapName, Predicate predicate) {
        super(mapName);
        this.predicate = predicate;
    }

    public QueryPartitionOperation() {
    }

    @Override
    public void run() {
        Collection<QueryableEntry> queryableEntries = this.mapService.getMapServiceContext().getMapContextQuerySupport().queryOnPartition(this.name, this.predicate, this.getPartitionId());
        this.result = new QueryResult();
        for (QueryableEntry entry : queryableEntries) {
            this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getIndexKey(), entry.getValueData()));
        }
        List<Integer> partitions = Collections.singletonList(this.getPartitionId());
        this.result.setPartitionIds(partitions);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.predicate);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.predicate = (Predicate)in.readObject();
    }
}

