/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.EntryEventData;
import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEventData;
import com.hazelcast.map.impl.MapEventPublisher;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.QueryEventFilter;
import com.hazelcast.map.impl.SyntheticEventFilter;
import com.hazelcast.map.impl.wan.MapReplicationRemove;
import com.hazelcast.map.impl.wan.MapReplicationUpdate;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.EventServiceImpl;
import com.hazelcast.wan.ReplicationEventObject;
import com.hazelcast.wan.WanReplicationPublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class MapEventPublisherSupport
implements MapEventPublisher {
    private final MapServiceContext mapServiceContext;

    protected MapEventPublisherSupport(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    @Override
    public void publishWanReplicationUpdate(String mapName, EntryView entryView) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        MapReplicationUpdate replicationEvent = new MapReplicationUpdate(mapName, mapContainer.getWanMergePolicy(), entryView);
        mapContainer.getWanReplicationPublisher().publishReplicationEvent(this.mapServiceContext.serviceName(), replicationEvent);
    }

    @Override
    public void publishWanReplicationRemove(String mapName, Data key, long removeTime) {
        MapReplicationRemove event = new MapReplicationRemove(mapName, key, removeTime);
        this.publishWanReplicationEventInternal(mapName, event);
    }

    @Override
    public void publishMapEvent(Address caller, String mapName, EntryEventType eventType, int numberOfEntriesAffected) {
        Collection<EventRegistration> registrations = this.getRegistrations(mapName);
        if (registrations.isEmpty()) {
            return;
        }
        String source = this.getThisNodesAddress();
        MapEventData mapEventData = new MapEventData(source, mapName, caller, eventType.getType(), numberOfEntriesAffected);
        this.publishEventInternal(registrations, mapEventData, mapName.hashCode());
    }

    @Override
    public void publishEvent(Address caller, String mapName, EntryEventType eventType, Data dataKey, Data dataOldValue, Data dataValue) {
        this.publishEvent(caller, mapName, eventType, false, dataKey, dataOldValue, dataValue);
    }

    @Override
    public void publishEvent(Address caller, String mapName, EntryEventType eventType, boolean syntheticEvent, Data dataKey, Data dataOldValue, Data dataValue) {
        Collection<EventRegistration> registrations = this.getRegistrations(mapName);
        if (registrations.isEmpty()) {
            return;
        }
        List<EventRegistration> registrationsWithValue = null;
        List<EventRegistration> registrationsWithoutValue = null;
        for (EventRegistration candidate : registrations) {
            EventFilter filter = candidate.getFilter();
            Result result = this.applyEventFilter(filter, syntheticEvent, dataKey, dataOldValue, dataValue, eventType);
            registrationsWithValue = this.initRegistrationsWithValue(registrationsWithValue, result);
            registrationsWithoutValue = this.initRegistrationsWithoutValue(registrationsWithoutValue, result);
            this.registerCandidate(result, candidate, registrationsWithValue, registrationsWithoutValue);
        }
        boolean withValueRegistrationExists = MapEventPublisherSupport.isNotEmpty(registrationsWithValue);
        boolean withoutValueRegistrationExists = MapEventPublisherSupport.isNotEmpty(registrationsWithoutValue);
        if (!withValueRegistrationExists && !withoutValueRegistrationExists) {
            return;
        }
        EntryEventData eventData = this.createEntryEventData(mapName, caller, dataKey, dataValue, dataOldValue, eventType.getType());
        int orderKey = this.pickOrderKey(dataKey);
        if (withValueRegistrationExists) {
            this.publishEventInternal(registrationsWithValue, eventData, orderKey);
        }
        if (withoutValueRegistrationExists) {
            this.publishEventInternal(registrationsWithoutValue, eventData.cloneWithoutValues(), orderKey);
        }
    }

    private List<EventRegistration> initRegistrationsWithoutValue(List<EventRegistration> registrationsWithoutValue, Result result) {
        if (registrationsWithoutValue != null) {
            return registrationsWithoutValue;
        }
        if (Result.NO_VALUE_INCLUDED.equals((Object)result)) {
            registrationsWithoutValue = new ArrayList<EventRegistration>();
        }
        return registrationsWithoutValue;
    }

    private List<EventRegistration> initRegistrationsWithValue(List<EventRegistration> registrationsWithValue, Result result) {
        if (registrationsWithValue != null) {
            return registrationsWithValue;
        }
        if (Result.VALUE_INCLUDED.equals((Object)result)) {
            registrationsWithValue = new ArrayList<EventRegistration>();
        }
        return registrationsWithValue;
    }

    private static <T> boolean isNotEmpty(Collection<T> collection) {
        return collection != null && !collection.isEmpty();
    }

    private Result applyEventFilter(EventFilter filter, boolean syntheticEvent, Data dataKey, Data dataOldValue, Data dataValue, EntryEventType eventType) {
        if (filter instanceof SyntheticEventFilter) {
            if (syntheticEvent) {
                return Result.NONE;
            }
            SyntheticEventFilter syntheticEventFilter = (SyntheticEventFilter)filter;
            filter = syntheticEventFilter.getFilter();
        }
        if (filter instanceof EventServiceImpl.EmptyFilter) {
            return Result.VALUE_INCLUDED;
        }
        if (filter instanceof QueryEventFilter) {
            return this.processQueryEventFilter(filter, eventType, dataKey, dataOldValue, dataValue);
        }
        if (filter instanceof EntryEventFilter) {
            return this.processEntryEventFilter(filter, dataKey);
        }
        throw new IllegalArgumentException("Unknown EventFilter type = [" + filter.getClass().getCanonicalName() + "]");
    }

    private Collection<EventRegistration> getRegistrations(String mapName) {
        MapServiceContext mapServiceContext = this.mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        EventService eventService = nodeEngine.getEventService();
        String serviceName = mapServiceContext.serviceName();
        return eventService.getRegistrations(serviceName, mapName);
    }

    private int pickOrderKey(Data key) {
        return key == null ? -1 : key.hashCode();
    }

    private void registerCandidate(Result result, EventRegistration candidate, Collection<EventRegistration> registrationsWithValue, Collection<EventRegistration> registrationsWithoutValue) {
        switch (result) {
            case VALUE_INCLUDED: {
                registrationsWithValue.add(candidate);
                break;
            }
            case NO_VALUE_INCLUDED: {
                registrationsWithoutValue.add(candidate);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a known result type [" + (Object)((Object)result) + "]");
            }
        }
    }

    private void publishEventInternal(Collection<EventRegistration> registrations, Object eventData, int orderKey) {
        MapServiceContext mapServiceContext = this.mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        EventService eventService = nodeEngine.getEventService();
        String serviceName = mapServiceContext.serviceName();
        eventService.publishEvent(serviceName, registrations, eventData, orderKey);
    }

    private String getThisNodesAddress() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        Address thisAddress = nodeEngine.getThisAddress();
        return thisAddress.toString();
    }

    private Result processEntryEventFilter(EventFilter filter, Data dataKey) {
        EntryEventFilter eventFilter = (EntryEventFilter)filter;
        if (!eventFilter.eval(dataKey)) {
            return Result.NONE;
        }
        if (eventFilter.isIncludeValue()) {
            return Result.VALUE_INCLUDED;
        }
        return Result.NO_VALUE_INCLUDED;
    }

    private Result processQueryEventFilter(EventFilter filter, EntryEventType eventType, Data dataKey, Data dataOldValue, Data dataValue) {
        Data testValue;
        QueryEventFilter queryEventFilter = (QueryEventFilter)filter;
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        SerializationService serializationService = nodeEngine.getSerializationService();
        QueryEntry entry = new QueryEntry(serializationService, dataKey, dataKey, testValue = eventType == EntryEventType.REMOVED || eventType == EntryEventType.EVICTED ? dataOldValue : dataValue);
        if (queryEventFilter.eval(entry)) {
            return queryEventFilter.isIncludeValue() ? Result.VALUE_INCLUDED : Result.NO_VALUE_INCLUDED;
        }
        return Result.NONE;
    }

    private void publishWanReplicationEventInternal(String mapName, ReplicationEventObject event) {
        MapServiceContext mapServiceContext = this.mapServiceContext;
        MapContainer mapContainer = mapServiceContext.getMapContainer(mapName);
        String serviceName = mapServiceContext.serviceName();
        WanReplicationPublisher wanReplicationPublisher = mapContainer.getWanReplicationPublisher();
        wanReplicationPublisher.publishReplicationEvent(serviceName, event);
    }

    private EntryEventData createEntryEventData(String mapName, Address caller, Data dataKey, Data dataNewValue, Data dataOldValue, int eventType) {
        String thisNodesAddress = this.getThisNodesAddress();
        return new EntryEventData(thisNodesAddress, mapName, caller, dataKey, dataNewValue, dataOldValue, eventType);
    }

    private static enum Result {
        VALUE_INCLUDED,
        NO_VALUE_INCLUDED,
        NONE;

    }
}

