/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.operation.BaseRemoveOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

public class MergeRemoveOperation
extends BaseRemoveOperation {
    private long removeTime;
    private transient boolean merged = false;

    public MergeRemoveOperation(String name, Data dataKey, long removeTime) {
        super(name, dataKey);
        this.removeTime = removeTime;
    }

    public MergeRemoveOperation() {
    }

    @Override
    public void run() {
        Record record = this.recordStore.getRecord(this.dataKey);
        if (record.getStatistics() != null && (record.getStatistics().getCreationTime() > this.removeTime || record.getStatistics().getLastUpdateTime() > this.removeTime)) {
            return;
        }
        this.recordStore.deleteRecord(this.dataKey);
        this.merged = true;
    }

    @Override
    public Object getResponse() {
        return this.merged;
    }

    @Override
    public void afterRun() {
        if (this.merged) {
            this.invalidateNearCaches();
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.merged;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(false);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.removeTime);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.removeTime = in.readLong();
    }

    @Override
    public String toString() {
        return "MergeRemoveOperation{" + this.name + "}";
    }
}

