/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VCardDateFormat {
    DATE_BASIC("\\d{8}", "yyyyMMdd"),
    DATE_EXTENDED("\\d{4}-\\d{2}-\\d{2}", "yyyy-MM-dd"),
    DATE_TIME_BASIC("\\d{8}T\\d{6}[-\\+]\\d{4}", "yyyyMMdd'T'HHmmssZ"),
    DATE_TIME_EXTENDED("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[-\\+]\\d{2}:\\d{2}", "yyyy-MM-dd'T'HH:mm:ssZ"){

        public DateFormat getDateFormat(TimeZone timezone) {
            SimpleDateFormat df = new SimpleDateFormat(this.formatStr){

                public Date parse(String str) throws ParseException {
                    int index = str.lastIndexOf(58);
                    str = str.substring(0, index) + str.substring(index + 1);
                    return super.parse(str);
                }

                public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                    StringBuffer sb = super.format(date, toAppendTo, fieldPosition);
                    sb.insert(sb.length() - 2, ':');
                    return sb;
                }
            };
            if (timezone != null) {
                df.setTimeZone(timezone);
            }
            return df;
        }
    }
    ,
    UTC_DATE_TIME_BASIC("\\d{8}T\\d{6}Z", "yyyyMMdd'T'HHmmss'Z'"){

        public DateFormat getDateFormat(TimeZone timezone) {
            timezone = TimeZone.getTimeZone("UTC");
            return super.getDateFormat(timezone);
        }
    }
    ,
    UTC_DATE_TIME_EXTENDED("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z", "yyyy-MM-dd'T'HH:mm:ss'Z'"){

        public DateFormat getDateFormat(TimeZone timezone) {
            timezone = TimeZone.getTimeZone("UTC");
            return super.getDateFormat(timezone);
        }
    }
    ,
    HCARD_DATE_TIME("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[-\\+]\\d{2}:?\\d{2}", "yyyy-MM-dd'T'HH:mm:ssZ"){

        public DateFormat getDateFormat(TimeZone timezone) {
            SimpleDateFormat df = new SimpleDateFormat(this.formatStr){

                public Date parse(String str) throws ParseException {
                    str = str.replaceAll("([-\\+]\\d{2}):(\\d{2})$", "$1$2");
                    return super.parse(str);
                }
            };
            if (timezone != null) {
                df.setTimeZone(timezone);
            }
            return df;
        }
    };

    private final Pattern pattern;
    protected final String formatStr;

    private VCardDateFormat(String regex, String formatStr) {
        this.pattern = Pattern.compile(regex);
        this.formatStr = formatStr;
    }

    public boolean matches(String dateStr) {
        return this.pattern.matcher(dateStr).matches();
    }

    public DateFormat getDateFormat() {
        return this.getDateFormat(null);
    }

    public DateFormat getDateFormat(TimeZone timezone) {
        SimpleDateFormat df = new SimpleDateFormat(this.formatStr);
        if (timezone != null) {
            df.setTimeZone(timezone);
        }
        return df;
    }

    public String format(Date date) {
        return this.format(date, null);
    }

    public String format(Date date, TimeZone timezone) {
        DateFormat df = this.getDateFormat(timezone);
        return df.format(date);
    }

    public static VCardDateFormat find(String dateStr) {
        for (VCardDateFormat format : VCardDateFormat.values()) {
            if (!format.matches(dateStr)) continue;
            return format;
        }
        return null;
    }

    public static Date parse(String dateStr) {
        VCardDateFormat format = VCardDateFormat.find(dateStr);
        if (format == null) {
            throw VCardDateFormat.parseException(dateStr);
        }
        DateFormat df = format.getDateFormat();
        try {
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            throw VCardDateFormat.parseException(dateStr);
        }
    }

    public static boolean dateHasTime(String dateStr) {
        return dateStr.contains("T");
    }

    public static boolean dateHasTimezone(String dateStr) {
        return dateStr.endsWith("Z") || dateStr.matches(".*?[-+]\\d\\d:?\\d\\d");
    }

    public static TimeZone parseTimeZoneId(String timezoneId) {
        TimeZone timezone = TimeZone.getTimeZone(timezoneId);
        return "GMT".equals(timezone.getID()) ? null : timezone;
    }

    private static IllegalArgumentException parseException(String dateStr) {
        return new IllegalArgumentException("Date string \"" + dateStr + "\" is not in a valid ISO-8601 format.");
    }
}

