/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.helper;

import java.util.Collection;
import java.util.Iterator;
import org.magicwerk.brownies.collections.BigList;

public class RangeList<E> {
    public AVLNode<E> root;
    private int size;

    public RangeList() {
    }

    public RangeList(Collection<? extends E> coll) {
        if (!coll.isEmpty()) {
            this.root = new AVLNode(coll);
            this.size = coll.size();
        }
    }

    public AVLNode<E> getIn(int index, int[] endIndex) {
        return this.root.getIn(index, endIndex);
    }

    public AVLNode<E> access(int index, int modify, int[] endIndex) {
        return this.root.access(index, modify, false, endIndex);
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        if (this.root != null) {
            this.root.toArray(array, this.root.relativePosition);
        }
        return array;
    }

    public void add(int index, E obj) {
        this.root = this.root == null ? new AVLNode(index, obj, null, null) : this.root.insert(index, obj);
        ++this.size;
    }

    public void remove(int index) {
        this.root = this.root.remove(index);
        --this.size;
    }

    public void clear() {
        this.root = null;
        this.size = 0;
    }

    private void checkInterval(int index, int startIndex, int endIndex) {
        if (index < startIndex || index > endIndex) {
            throw new IndexOutOfBoundsException("Invalid index:" + index + ", size=" + this.size());
        }
    }

    public static class AVLNode<E> {
        public AVLNode<E> left;
        public boolean leftIsPrevious;
        public AVLNode<E> right;
        public boolean rightIsNext;
        public int height;
        public int relativePosition;
        private E value;

        private AVLNode(int relativePosition, E obj, AVLNode<E> rightFollower, AVLNode<E> leftFollower) {
            this.relativePosition = relativePosition;
            this.value = obj;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private AVLNode(Collection<? extends E> coll) {
            this(coll.iterator(), 0, coll.size() - 1, 0, null, null);
        }

        private AVLNode(Iterator<? extends E> iterator, int start, int end, int absolutePositionOfParent, AVLNode<E> prev, AVLNode<E> next) {
            int mid = start + (end - start) / 2;
            if (start < mid) {
                this.left = new AVLNode<E>(iterator, start, mid - 1, mid, prev, this);
            } else {
                this.leftIsPrevious = true;
                this.left = prev;
            }
            this.value = iterator.next();
            this.relativePosition = mid - absolutePositionOfParent;
            if (mid < end) {
                this.right = new AVLNode<E>(iterator, mid + 1, end, mid, this, next);
            } else {
                this.rightIsNext = true;
                this.right = next;
            }
            this.recalcHeight();
        }

        public E getValue() {
            return this.value;
        }

        public void setValue(E obj) {
            this.value = obj;
        }

        AVLNode<E> get2(int index) {
            AVLNode<E> nextNode;
            int indexRelativeToMe = index - this.relativePosition;
            if (indexRelativeToMe == 0) {
                return this;
            }
            AVLNode<E> aVLNode = nextNode = indexRelativeToMe < 0 ? this.getLeftSubTree() : this.getRightSubTree();
            if (nextNode == null) {
                return null;
            }
            return nextNode.get2(indexRelativeToMe);
        }

        AVLNode<E> getIn(int index, int[] idx) {
            assert (index >= 0);
            if (this.relativePosition == 0) {
                return this;
            }
            if (idx[0] == 0) {
                idx[0] = this.relativePosition;
            }
            AVLNode<E> leftNode = this.getLeftSubTree();
            int leftIndex = idx[0] - ((BigList.Block)this.getValue()).size();
            if (index >= leftIndex && index < idx[0]) {
                return this;
            }
            if (index < idx[0]) {
                AVLNode<E> nextNode = this.getLeftSubTree();
                if (nextNode == null) {
                    return this;
                }
                idx[0] = idx[0] + nextNode.relativePosition;
                return nextNode.getIn(index, idx);
            }
            AVLNode<E> nextNode = this.getRightSubTree();
            if (nextNode == null) {
                return this;
            }
            idx[0] = idx[0] + nextNode.relativePosition;
            return nextNode.getIn(index, idx);
        }

        AVLNode<E> access(int index, int modify, boolean wasLeft, int[] idx) {
            assert (index >= 0);
            if (this.relativePosition == 0) {
                if (modify != 0) {
                    this.relativePosition += modify;
                }
                return this;
            }
            if (idx[0] == 0) {
                idx[0] = this.relativePosition;
            }
            AVLNode<E> leftNode = this.getLeftSubTree();
            int leftIndex = idx[0] - ((BigList.Block)this.getValue()).size();
            if (index >= leftIndex && index < idx[0]) {
                this.relativePosition = this.relativePosition > 0 ? (this.relativePosition += modify) : (this.relativePosition -= modify);
                return this;
            }
            if (index < idx[0]) {
                AVLNode<E> nextNode = this.getLeftSubTree();
                if (nextNode == null || !wasLeft) {
                    this.relativePosition = this.relativePosition > 0 ? (this.relativePosition += modify) : (this.relativePosition -= modify);
                    wasLeft = true;
                }
                if (nextNode == null) {
                    return this;
                }
                idx[0] = idx[0] + nextNode.relativePosition;
                return nextNode.access(index, modify, wasLeft, idx);
            }
            AVLNode<E> nextNode = this.getRightSubTree();
            if (nextNode == null || wasLeft) {
                this.relativePosition = this.relativePosition > 0 ? (this.relativePosition += modify) : (this.relativePosition -= modify);
                wasLeft = false;
            }
            if (nextNode == null) {
                return this;
            }
            idx[0] = idx[0] + nextNode.relativePosition;
            return nextNode.access(index, modify, wasLeft, idx);
        }

        void toArray(Object[] array, int index) {
            array[index] = this.value;
            if (this.getLeftSubTree() != null) {
                this.left.toArray(array, index + this.left.relativePosition);
            }
            if (this.getRightSubTree() != null) {
                this.right.toArray(array, index + this.right.relativePosition);
            }
        }

        public AVLNode<E> next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        public AVLNode<E> nextTop() {
            AVLNode<E> top = null;
            int topHei = this.height;
            AVLNode<E> next = this;
            while ((next = next.next()) != null) {
                if (next.height <= topHei) continue;
                top = next;
                topHei = top.height;
            }
            return top;
        }

        public AVLNode<E> prevTop() {
            AVLNode<E> top = null;
            int topHei = this.height;
            AVLNode<E> prev = this;
            while ((prev = prev.previous()) != null) {
                if (prev.height <= topHei) continue;
                top = prev;
                topHei = top.height;
            }
            return top;
        }

        public AVLNode<E> prevDown() {
            AVLNode<E> prev = this.previous();
            if (prev != null && prev.height < this.height) {
                return prev;
            }
            return null;
        }

        public AVLNode<E> previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        AVLNode<E> insert(int index, E obj) {
            assert (this.relativePosition != 0);
            int indexRelativeToMe = index - this.relativePosition;
            if (indexRelativeToMe < 0) {
                return this.insertOnLeft(indexRelativeToMe, obj);
            }
            return this.insertOnRight(indexRelativeToMe, obj);
        }

        public AVLNode<E> insertOnLeft2(int indexRelativeToMe, E obj) {
            if (this.getLeftSubTree() == null) {
                this.setLeft(new AVLNode<E>(indexRelativeToMe, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(indexRelativeToMe, obj), null);
            }
            AVLNode<E> ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        public AVLNode<E> insertOnLeft(int indexRelativeToMe, E obj) {
            if (this.getLeftSubTree() == null) {
                this.setLeft(new AVLNode<E>(-1, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(indexRelativeToMe, obj), null);
            }
            AVLNode<E> ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private AVLNode<E> insertOnRight(int indexRelativeToMe, E obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new AVLNode<E>(1, obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(indexRelativeToMe, obj), null);
            }
            AVLNode<E> ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        public AVLNode<E> getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        public AVLNode<E> getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        public AVLNode<E> max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        public AVLNode<E> min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        AVLNode<E> remove(int index) {
            int indexRelativeToMe = index - this.relativePosition;
            if (indexRelativeToMe == 0) {
                return this.removeSelf();
            }
            if (indexRelativeToMe > 0) {
                this.setRight(this.right.remove(indexRelativeToMe), this.right.right);
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                this.setLeft(this.left.remove(indexRelativeToMe), this.left.left);
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode<E> removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(super.removeMax(), this.right.right);
            if (this.relativePosition < 0) {
                ++this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode<E> removeMin() {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(super.removeMin(), this.left.left);
            if (this.relativePosition > 0) {
                --this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode<E> removeSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                if (this.relativePosition > 0) {
                    this.left.relativePosition = this.left.relativePosition + (this.relativePosition + (this.relativePosition > 0 ? 0 : 1));
                }
                super.setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                this.right.relativePosition = this.right.relativePosition + (this.relativePosition - (this.relativePosition < 0 ? 0 : 1));
                super.setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                AVLNode<E> rightMin = this.right.min();
                this.value = rightMin.value;
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = super.removeMin();
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                AVLNode<E> leftMax = this.left.max();
                this.value = leftMax.value;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                AVLNode<E> leftPrevious = this.left.left;
                this.left = super.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                }
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this;
        }

        private AVLNode<E> balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (super.heightRightMinusLeft() > 0) {
                        this.setLeft(super.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (super.heightRightMinusLeft() < 0) {
                        this.setRight(super.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(AVLNode<E> node) {
            if (node == null) {
                return 0;
            }
            return node.relativePosition;
        }

        private int setOffset(AVLNode<E> node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relativePosition = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(AVLNode<E> node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private AVLNode<E> rotateLeft() {
            AVLNode<E> newTop = this.right;
            AVLNode<E> movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relativePosition + this.getOffset(newTop);
            int myNewPosition = -newTop.relativePosition;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            this.setRight(movedNode, newTop);
            super.setLeft(this, null);
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            return newTop;
        }

        private AVLNode<E> rotateRight() {
            AVLNode<E> newTop = this.left;
            AVLNode<E> movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relativePosition + this.getOffset(newTop);
            int myNewPosition = -newTop.relativePosition;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            this.setLeft(movedNode, newTop);
            super.setRight(this, null);
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            return newTop;
        }

        private void setLeft(AVLNode<E> node, AVLNode<E> previous) {
            this.leftIsPrevious = node == null;
            this.left = this.leftIsPrevious ? previous : node;
            this.recalcHeight();
        }

        private void setRight(AVLNode<E> node, AVLNode<E> next) {
            this.rightIsNext = node == null;
            this.right = this.rightIsNext ? next : node;
            this.recalcHeight();
        }

        public String toString() {
            return "AVLNode(" + this.relativePosition + ',' + (this.left != null) + ',' + this.value + ',' + (this.getRightSubTree() != null) + ", faedelung " + this.rightIsNext + " )";
        }
    }
}

