/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IsoOutputStream
extends FilterOutputStream {
    private int streamPosition;

    public IsoOutputStream(OutputStream os) {
        super(os);
    }

    public long getStreamPosition() {
        return this.streamPosition;
    }

    public void writeUInt64(long uint64) throws IOException {
        this.writeUInt32((int)(uint64 >> 32));
        this.writeUInt32((int)uint64);
    }

    public void writeUInt32(long uint32) throws IOException {
        this.writeUInt16((int)(uint32 & 0xFFFFFFFFFFFF0000L) >> 16);
        this.writeUInt16((int)uint32 & 0xFFFF);
    }

    public void writeInt32(int int32) throws IOException {
        this.out.write(int32 >>> 24 & 0xFF);
        this.out.write(int32 >>> 16 & 0xFF);
        this.out.write(int32 >>> 8 & 0xFF);
        this.out.write(int32 >>> 0 & 0xFF);
        this.streamPosition += 4;
    }

    public void writeUInt24(int uint24) throws IOException {
        this.writeUInt16(uint24 >> 8);
        this.writeUInt8(uint24);
    }

    public void writeUInt16(int uint16) throws IOException {
        this.writeUInt8(uint16 >> 8);
        this.writeUInt8(uint16);
    }

    public void writeUInt8(int uint8) throws IOException {
        this.write(uint8 & 0xFF);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.streamPosition;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.streamPosition += len;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.streamPosition += b.length;
    }

    public void writeStringZeroTerm(String str) throws IOException {
        str = str == null ? "" : str;
        str = str + "\u0000";
        byte[] toBeWritten = str.getBytes("UTF-8");
        this.write(toBeWritten);
    }

    public void writeStringNoTerm(String str) throws IOException {
        if (str != null) {
            byte[] toBeWritten = str.getBytes("UTF-8");
            this.write(toBeWritten);
        }
    }

    public void writeIso639(String language) throws IOException {
        int bits = 0;
        for (int i = 0; i < 3; ++i) {
            bits += language.getBytes()[i] - 96 << (2 - i) * 5;
        }
        this.writeUInt16(bits);
    }

    public void writeFixedPont1616(double v) throws IOException {
        int result = (int)(v * 65536.0);
        this.write((result & 0xFF000000) >> 24);
        this.write((result & 0xFF0000) >> 16);
        this.write((result & 0xFF00) >> 8);
        this.write(result & 0xFF);
    }

    public void writeFixedPont88(double v) throws IOException {
        short result = (short)(v * 256.0);
        this.write((result & 0xFF00) >> 8);
        this.write(result & 0xFF);
    }

    public void writeUInt32BE(long uint32) throws IOException {
        this.writeUInt16BE((int)uint32 & 0xFFFF);
        this.writeUInt16BE((int)(uint32 & 0xFFFFFFFFFFFF0000L) >> 16);
    }

    public void writeUInt16BE(int uint16) throws IOException {
        this.writeUInt8(uint16);
        this.writeUInt8(uint16 >> 8);
    }
}

