/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.queue.QueueBackupAwareOperation;
import com.hazelcast.queue.tx.TxnPrepareBackupOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class TxnPrepareOperation
extends QueueBackupAwareOperation {
    long itemId;
    boolean pollOperation;
    String transactionId;

    public TxnPrepareOperation() {
    }

    public TxnPrepareOperation(String name, long itemId, boolean pollOperation, String transactionId) {
        super(name);
        this.itemId = itemId;
        this.pollOperation = pollOperation;
        this.transactionId = transactionId;
    }

    @Override
    public void run() throws Exception {
        this.response = this.getOrCreateContainer().txnEnsureReserve(this.itemId);
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnPrepareBackupOperation(this.name, this.itemId, this.pollOperation, this.transactionId);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.pollOperation);
        out.writeUTF(this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.pollOperation = in.readBoolean();
        this.transactionId = in.readUTF();
    }

    @Override
    public int getId() {
        return 28;
    }
}

