/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.SourceFile;
import com.openexchange.obs.api.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class SourceFileParser {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private SourceFileParser() {
    }

    public static SourceFile[] parse(InputStream is) throws BuildServiceException {
        Document document;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(is);
            NodeList childs = document.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if ("directory".equals(node.getNodeName())) {
                    return SourceFileParser.parseDirectory(node);
                }
                if (3 == node.getNodeType()) continue;
                throw new BuildServiceException("Unknown node in build result \"" + node.getNodeName() + "\".");
            }
        }
        catch (ParserConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        throw new BuildServiceException("Unable to parse build result. " + Tools.transform(document));
    }

    private static SourceFile[] parseDirectory(Node directoryNode) throws BuildServiceException {
        NodeList childs = directoryNode.getChildNodes();
        NamedNodeMap attributes = directoryNode.getAttributes();
        String pkgName = attributes.getNamedItem("name").getNodeValue();
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if ("entry".equals(node.getNodeName())) {
                sourceFiles.add(SourceFileParser.parseStatus(pkgName, node));
                continue;
            }
            if (3 == node.getNodeType()) continue;
            throw new BuildServiceException("Unknown node in result \"" + node.getNodeName() + "\" \"" + node.getNodeValue() + "\".");
        }
        return sourceFiles.toArray(new SourceFile[sourceFiles.size()]);
    }

    private static SourceFile parseStatus(String pkgName, Node entry) throws BuildServiceException {
        NamedNodeMap attributes = entry.getAttributes();
        Node sizeNode = attributes.getNamedItem("size");
        String size = null == sizeNode ? null : sizeNode.getNodeValue();
        Node mtimeNode = attributes.getNamedItem("mtime");
        String mtime = null == mtimeNode ? null : mtimeNode.getNodeValue();
        Node errorNode = attributes.getNamedItem("error");
        SourceFile pkg = new SourceFile(pkgName, attributes.getNamedItem("name").getNodeValue(), attributes.getNamedItem("md5").getNodeValue(), size, mtime);
        if (null != errorNode) {
            pkg.setError(errorNode.getNodeValue());
        }
        return pkg;
    }
}

