/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.jaxrs.ext.search.Beanspector;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.PrimitiveSearchCondition;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckCondition;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSearchCondition<T>
implements SearchCondition<T> {
    private static Set<ConditionType> supportedTypes = new HashSet<ConditionType>();
    private ConditionType joiningType = ConditionType.AND;
    private T condition;
    private List<SearchCondition<T>> scts;

    public SimpleSearchCondition(ConditionType cType, T condition) {
        if (cType == null) {
            throw new IllegalArgumentException("cType is null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("condition is null");
        }
        if (!supportedTypes.contains((Object)cType)) {
            throw new IllegalArgumentException("unsupported condition type: " + cType.name());
        }
        this.condition = condition;
        this.scts = this.createConditions(null, null, null, cType);
    }

    public SimpleSearchCondition(Map<String, ConditionType> getters2operators, Map<String, String> realGetters, Map<String, Beanspector.TypeInfo> propertyTypeInfo, T condition) {
        if (getters2operators == null) {
            throw new IllegalArgumentException("getters2operators is null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("condition is null");
        }
        if (this.isBuiltIn(condition)) {
            throw new IllegalArgumentException("mapped operators strategy is not supported for primitive type " + condition.getClass().getName());
        }
        this.condition = condition;
        for (ConditionType ct : getters2operators.values()) {
            if (supportedTypes.contains((Object)ct)) continue;
            throw new IllegalArgumentException("unsupported condition type: " + ct.name());
        }
        this.scts = this.createConditions(getters2operators, realGetters, propertyTypeInfo, null);
    }

    public SimpleSearchCondition(Map<String, ConditionType> getters2operators, T condition) {
        this(getters2operators, null, null, condition);
    }

    @Override
    public T getCondition() {
        return this.condition;
    }

    @Override
    public ConditionType getConditionType() {
        if (this.scts.size() > 1) {
            return this.joiningType;
        }
        return this.scts.get(0).getStatement().getCondition();
    }

    @Override
    public List<SearchCondition<T>> getSearchConditions() {
        if (this.scts.size() > 1) {
            return Collections.unmodifiableList(this.scts);
        }
        return null;
    }

    private List<SearchCondition<T>> createConditions(Map<String, ConditionType> getters2operators, Map<String, String> realGetters, Map<String, Beanspector.TypeInfo> propertyTypeInfo, ConditionType sharedType) {
        if (this.isBuiltIn(this.condition)) {
            return Collections.singletonList(new PrimitiveSearchCondition<T>(null, this.condition, null, sharedType, this.condition));
        }
        ArrayList<SearchCondition<T>> list = new ArrayList<SearchCondition<T>>();
        Map<String, Object> get2val = this.getGettersAndValues();
        Set<String> keySet = get2val != null ? get2val.keySet() : ((SearchBean)this.condition).getKeySet();
        for (String getter : keySet) {
            Object rval;
            ConditionType ct = getters2operators == null ? sharedType : getters2operators.get(getter);
            if (ct == null || (rval = get2val != null ? get2val.get(getter) : ((SearchBean)this.condition).get(getter)) == null) continue;
            String realGetter = realGetters != null && realGetters.containsKey(getter) ? realGetters.get(getter) : getter;
            Beanspector.TypeInfo tInfo = propertyTypeInfo != null ? propertyTypeInfo.get(getter) : null;
            Class<?> genType = tInfo != null ? tInfo.getGenericType() : rval.getClass();
            CollectionCheckInfo checkInfo = tInfo != null ? tInfo.getCollectionCheckInfo() : null;
            PrimitiveSearchCondition<T> pc = checkInfo == null ? new PrimitiveSearchCondition<T>(realGetter, rval, genType, ct, this.condition) : new CollectionCheckCondition<T>(realGetter, rval, genType, ct, this.condition, checkInfo);
            list.add(pc);
        }
        if (list.isEmpty()) {
            throw new IllegalStateException("This search condition is empty and can not be used");
        }
        return list;
    }

    @Override
    public boolean isMet(T pojo) {
        for (SearchCondition<T> sc : this.scts) {
            if (sc.isMet(pojo)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Object> getGettersAndValues() {
        if (!SearchBean.class.isAssignableFrom(this.condition.getClass())) {
            HashMap<String, Object> getters2values = new HashMap<String, Object>();
            Beanspector<T> beanspector = new Beanspector<T>(this.condition);
            for (String getter : beanspector.getGettersNames()) {
                Object value = this.getValue(beanspector, getter, this.condition);
                getters2values.put(getter, value);
            }
            getters2values.keySet().remove("class");
            return getters2values;
        }
        return null;
    }

    private Object getValue(Beanspector<T> beanspector, String getter, T pojo) {
        try {
            return beanspector.swap(pojo).getValue(getter);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private boolean isBuiltIn(T pojo) {
        return pojo.getClass().getName().startsWith("java.lang");
    }

    @Override
    public List<T> findAll(Collection<T> pojos) {
        ArrayList<T> result = new ArrayList<T>();
        for (T pojo : pojos) {
            if (!this.isMet(pojo)) continue;
            result.add(pojo);
        }
        return result;
    }

    public String toSQL(String table, String ... columns) {
        return SearchUtils.toSQL(this, table, columns);
    }

    @Override
    public PrimitiveStatement getStatement() {
        if (this.scts.size() == 1) {
            return this.scts.get(0).getStatement();
        }
        return null;
    }

    @Override
    public void accept(SearchConditionVisitor<T, ?> visitor) {
        visitor.visit(this);
    }

    static {
        supportedTypes.add(ConditionType.EQUALS);
        supportedTypes.add(ConditionType.NOT_EQUALS);
        supportedTypes.add(ConditionType.GREATER_THAN);
        supportedTypes.add(ConditionType.GREATER_OR_EQUALS);
        supportedTypes.add(ConditionType.LESS_THAN);
        supportedTypes.add(ConditionType.LESS_OR_EQUALS);
    }
}

