/*
 * Copyright (c) 2008-2013, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.spi.impl;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;

public final class TargetInvocationImpl extends InvocationImpl {

    private final Address target;

    public TargetInvocationImpl(NodeEngineImpl nodeEngine, String serviceName, Operation op,
                                Address target, int tryCount, long tryPauseMillis, long callTimeout,
                                Callback<Object> callback) {
        super(nodeEngine, serviceName, op, op.getPartitionId(), op.getReplicaIndex(),
                tryCount, tryPauseMillis, callTimeout, callback);
        this.target = target;
    }

    public final Address getTarget() {
        return target;
    }

    final ExceptionAction onException(Throwable t) {
        return t instanceof MemberLeftException ? ExceptionAction.THROW_EXCEPTION : op.onException(t);
    }
}
