/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class KMP {
    private char[] x;
    private int m;
    private int[] kmpNext;

    private static void preKmp(char[] x, int[] kmpNext) {
        int m = x.length - 1;
        int i = 0;
        kmpNext[0] = -1;
        int j = -1;
        while (i < m) {
            while (j > -1 && x[i] != x[j]) {
                j = kmpNext[j];
            }
            if (x[++i] == x[++j]) {
                kmpNext[i] = kmpNext[j];
                continue;
            }
            kmpNext[i] = j;
        }
    }

    public static List<Integer> findAll(String pattern, String source) {
        char[] ptrn = pattern.toCharArray();
        char[] y = source.toCharArray();
        char[] x = new char[ptrn.length + 1];
        System.arraycopy(ptrn, 0, x, 0, ptrn.length);
        int m = ptrn.length;
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int[] kmpNext = new int[x.length];
        KMP.preKmp(x, kmpNext);
        int i = 0;
        for (int j = 0; j < n; ++j) {
            while (i > -1 && x[i] != y[j]) {
                i = kmpNext[i];
            }
            if (++i < m) continue;
            result.add(j - i);
            i = kmpNext[i];
        }
        return result;
    }

    public static KMP compile(String pattern) {
        char[] ptrn = pattern.toCharArray();
        char[] x = new char[ptrn.length + 1];
        System.arraycopy(ptrn, 0, x, 0, ptrn.length);
        int m = ptrn.length;
        int[] kmpNext = new int[x.length];
        KMP.preKmp(x, kmpNext);
        KMP kmp = new KMP();
        kmp.kmpNext = kmpNext;
        kmp.m = m;
        kmp.x = x;
        return kmp;
    }

    public List<Integer> findAll(String source) {
        char[] y = source.toCharArray();
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        for (int j = 0; j < n; ++j) {
            while (i > -1 && this.x[i] != y[j]) {
                i = this.kmpNext[i];
            }
            if (++i < this.m) continue;
            result.add(j - i);
            i = this.kmpNext[i];
        }
        return result;
    }
}

