/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.Member;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.MapConfigAdapter;
import com.hazelcast.management.operation.GetMapConfigOperation;
import com.hazelcast.management.operation.UpdateMapConfigOperation;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.Set;

public class MapConfigRequest
implements ConsoleRequest {
    private String map;
    private MapConfig config;
    private boolean update;
    private Address target;

    public MapConfigRequest() {
    }

    public MapConfigRequest(String map, MapConfig config) {
        this.map = map;
        this.config = config;
        this.update = true;
    }

    public MapConfigRequest(String map, Address target) {
        this.map = map;
        this.target = target;
        this.update = false;
    }

    public Address getTarget() {
        return this.target;
    }

    public void setTarget(Address target) {
        this.target = target;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, ObjectDataOutput dos) throws Exception {
        dos.writeBoolean(this.update);
        if (this.update) {
            Set<Member> members = mcs.getHazelcastInstance().getCluster().getMembers();
            for (Member member : members) {
                mcs.callOnMember(member, new UpdateMapConfigOperation(this.map, this.config));
            }
            dos.writeUTF("success");
        } else {
            MapConfig cfg = (MapConfig)mcs.callOnAddress(this.target, new GetMapConfigOperation(this.map));
            if (cfg != null) {
                dos.writeBoolean(true);
                new MapConfigAdapter(cfg).writeData(dos);
            } else {
                dos.writeBoolean(false);
            }
        }
    }

    @Override
    public Object readResponse(ObjectDataInput in) throws IOException {
        this.update = in.readBoolean();
        if (!this.update) {
            if (in.readBoolean()) {
                MapConfigAdapter adapter = new MapConfigAdapter();
                adapter.readData(in);
                return adapter.getMapConfig();
            }
            return null;
        }
        return in.readUTF();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.map);
        out.writeBoolean(this.update);
        if (this.update) {
            new MapConfigAdapter(this.config).writeData(out);
        } else {
            this.target.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.map = in.readUTF();
        this.update = in.readBoolean();
        if (this.update) {
            MapConfigAdapter adapter = new MapConfigAdapter();
            adapter.readData(in);
            this.config = adapter.getMapConfig();
        } else {
            this.target = new Address();
            this.target.readData(in);
        }
    }
}

