/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.GoogleBaseAttributeType;

public class GoogleBaseAttributeId {
    private final String name;
    private final GoogleBaseAttributeType type;

    public GoogleBaseAttributeId(String name, GoogleBaseAttributeType type) {
        if (name == null) {
            throw new NullPointerException("attribute 'name' is required");
        }
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public GoogleBaseAttributeType getType() {
        return this.type;
    }

    public String toString() {
        if (this.type == null) {
            return this.name;
        }
        return this.name + "(" + this.type + ")";
    }

    public int hashCode() {
        int retval = 19 + this.name.hashCode();
        if (this.type != null) {
            retval = retval * 37 + this.type.hashCode();
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GoogleBaseAttributeId)) {
            return false;
        }
        GoogleBaseAttributeId other = (GoogleBaseAttributeId)o;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null) {
            return other.type == null;
        }
        return this.type.equals(other.type);
    }
}

