/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.AddressUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public final class Address
implements DataSerializable {
    private static final long serialVersionUID = -7626390274220424603L;
    private static final byte IPv4 = 4;
    private static final byte IPv6 = 6;
    private int port = -1;
    private String host;
    private byte type;
    private transient String scopeId;
    private transient boolean hostSet;

    public Address() {
    }

    public Address(String host, int port) throws UnknownHostException {
        this(host, InetAddress.getByName(host), port);
        this.hostSet = !AddressUtil.isIpAddress(host);
    }

    public Address(InetAddress inetAddress, int port) {
        this(null, inetAddress, port);
        this.hostSet = false;
    }

    public Address(InetSocketAddress inetSocketAddress) {
        this(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    private Address(String hostname, InetAddress inetAddress, int port) {
        this.type = (byte)(inetAddress instanceof Inet4Address ? 4 : 6);
        String[] addressArgs = inetAddress.getHostAddress().split("\\%");
        String string = this.host = hostname != null ? hostname : addressArgs[0];
        if (addressArgs.length == 2) {
            this.scopeId = addressArgs[1];
        }
        this.port = port;
    }

    public Address(Address address) {
        this.host = address.host;
        this.port = address.port;
        this.type = address.type;
        this.scopeId = address.scopeId;
        this.hostSet = address.hostSet;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.port);
        out.write(this.type);
        if (this.host != null) {
            byte[] address = this.host.getBytes();
            out.writeInt(address.length);
            out.write(address);
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.port = in.readInt();
        this.type = in.readByte();
        int len = in.readInt();
        if (len > 0) {
            byte[] address = new byte[len];
            in.readFully(address);
            this.host = new String(address);
        }
    }

    public void writeObject(ByteBuffer buffer) {
        buffer.putInt(this.port);
        buffer.put(this.type);
        if (this.host != null) {
            byte[] address = this.host.getBytes();
            buffer.putInt(address.length);
            buffer.put(address);
        } else {
            buffer.putInt(0);
        }
    }

    public void readObject(ByteBuffer buffer) {
        this.port = buffer.getInt();
        this.type = buffer.get();
        int len = buffer.getInt();
        if (len > 0) {
            byte[] address = new byte[len];
            buffer.get(address);
            this.host = new String(address);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        return "Address[" + this.getHost() + "]:" + this.port;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getScopedHost());
    }

    public InetSocketAddress getInetSocketAddress() throws UnknownHostException {
        return new InetSocketAddress(this.getInetAddress(), this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        return this.port == address.port && this.type == address.type && this.host.equals(address.host);
    }

    public int hashCode() {
        return this.hash(this.host.getBytes()) * 29 + this.port;
    }

    private int hash(byte[] bytes) {
        int hash = 0;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hash = hash * 29 + b;
            ++n2;
        }
        return hash;
    }

    public boolean isIPv4() {
        return this.type == 4;
    }

    public boolean isIPv6() {
        return this.type == 6;
    }

    public String getScopeId() {
        return this.isIPv6() ? this.scopeId : null;
    }

    public void setScopeId(String scopeId) {
        if (this.isIPv6()) {
            this.scopeId = scopeId;
        }
    }

    public String getScopedHost() {
        return this.isIPv4() || this.hostSet || this.scopeId == null ? this.getHost() : String.valueOf(this.getHost()) + "%" + this.scopeId;
    }
}

