/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public final class PutBackupOperation
extends KeyBasedMapOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private boolean unlockKey = false;

    public PutBackupOperation(String name, Data dataKey, Data dataValue, long ttl) {
        super(name, dataKey, dataValue, ttl);
    }

    public PutBackupOperation(String name, Data dataKey, Data dataValue, long ttl, boolean unlockKey) {
        super(name, dataKey, dataValue, ttl);
        this.unlockKey = unlockKey;
    }

    public PutBackupOperation() {
    }

    @Override
    public void run() {
        Record record = this.recordStore.getRecord(this.dataKey);
        if (record == null) {
            record = this.mapService.createRecord(this.name, this.dataKey, this.dataValue, this.ttl, false);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.recordStore.putRecord(this.dataKey, record);
        } else {
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.mapContainer.getRecordFactory().setValue(record, this.dataValue);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        if (this.unlockKey) {
            this.recordStore.forceUnlock(this.dataKey);
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.unlockKey);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.unlockKey = in.readBoolean();
    }

    public String toString() {
        return "PutBackupOperation{" + this.name + "}";
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }

    private void updateSizeEstimator(long recordSize) {
        this.recordStore.getSizeEstimator().add(recordSize);
    }

    private long calculateRecordSize(Record record) {
        return this.recordStore.getSizeEstimator().getCost(record);
    }
}

