/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffUtil;
import org.jaudiotagger.audio.aiff.Chunk;
import org.jaudiotagger.audio.aiff.ChunkHeader;
import org.jaudiotagger.audio.generic.Utils;

public class CommonChunk
extends Chunk {
    private AiffAudioHeader aiffHeader;

    public CommonChunk(ChunkHeader hdr, RandomAccessFile raf, AiffAudioHeader aHdr) {
        super(raf, hdr);
        this.aiffHeader = aHdr;
    }

    public boolean readChunk() throws IOException {
        int numChannels = Utils.readUint16(this.raf);
        long numSampleFrames = Utils.readUint32(this.raf);
        int sampleSize = Utils.readUint16(this.raf);
        this.bytesLeft -= 8L;
        String compressionType = null;
        String compressionName = null;
        double sampleRate = AiffUtil.read80BitDouble(this.raf);
        this.bytesLeft -= 10L;
        if (this.aiffHeader.getFileType() == AiffAudioHeader.FileType.AIFCTYPE) {
            if (this.bytesLeft == 0L) {
                return false;
            }
            compressionType = AiffUtil.read4Chars(this.raf);
            if (compressionType.equals("sowt")) {
                this.aiffHeader.setEndian(AiffAudioHeader.Endian.LITTLE_ENDIAN);
            }
            this.bytesLeft -= 4L;
            compressionName = AiffUtil.readPascalString(this.raf);
            this.bytesLeft -= (long)(compressionName.length() + 1);
        }
        this.aiffHeader.setBitsPerSample(sampleSize);
        this.aiffHeader.setSamplingRate((int)sampleRate);
        this.aiffHeader.setChannelNumber(numChannels);
        this.aiffHeader.setLength((int)((double)numSampleFrames / sampleRate));
        this.aiffHeader.setPreciseLength((float)((double)numSampleFrames / sampleRate));
        this.aiffHeader.setLossless(true);
        if (compressionType != null) {
            if (!compressionType.equals("NONE")) {
                if (compressionType.equals("raw ")) {
                    compressionName = "PCM 8-bit offset-binary";
                } else if (compressionType.equals("twos")) {
                    compressionName = "PCM 16-bit twos-complement big-endian";
                } else if (compressionType.equals("sowt")) {
                    compressionName = "PCM 16-bit twos-complement little-endian";
                } else if (compressionType.equals("fl32")) {
                    compressionName = "PCM 32-bit integer";
                } else if (compressionType.equals("fl64")) {
                    compressionName = "PCM 64-bit floating point";
                } else if (compressionType.equals("in24")) {
                    compressionName = "PCM 24-bit integer";
                } else if (compressionType.equals("in32")) {
                    compressionName = "PCM 32-bit integer";
                } else {
                    this.aiffHeader.setLossless(false);
                }
            }
            this.aiffHeader.setAudioEncoding(compressionName);
            String name = compressionName;
            if (name == null || name.length() == 0) {
                name = compressionType;
            }
        }
        return true;
    }
}

