/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.monitor.AtomicNumberOperationsCounter;
import com.hazelcast.impl.monitor.LocalAtomicNumberStatsImpl;
import com.hazelcast.monitor.LocalAtomicNumberOperationStats;
import com.hazelcast.monitor.LocalAtomicNumberStats;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;

public class AtomicNumberProxyImpl
extends FactoryAwareNamedProxy
implements AtomicNumberProxy {
    private transient AtomicNumberProxy base = null;
    Data nameAsData = null;

    public AtomicNumberProxyImpl() {
    }

    AtomicNumberProxyImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.base = new AtomicNumberProxyReal();
    }

    Data getNameAsData() {
        if (this.nameAsData == null) {
            this.nameAsData = IOUtil.toData(this.name);
        }
        return this.nameAsData;
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (AtomicNumberProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    public String toString() {
        return "AtomicLong [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicNumberProxyImpl that = (AtomicNumberProxyImpl)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    @Override
    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    @Override
    public String getName() {
        this.ensure();
        return this.base.getName();
    }

    @Override
    public String getLongName() {
        return this.name;
    }

    @Override
    public long addAndGet(long delta) {
        this.ensure();
        return this.base.addAndGet(delta);
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        this.ensure();
        return this.base.compareAndSet(expect, update);
    }

    @Override
    public long decrementAndGet() {
        this.ensure();
        return this.base.decrementAndGet();
    }

    @Override
    public long get() {
        this.ensure();
        return this.base.get();
    }

    @Override
    public long getAndAdd(long delta) {
        this.ensure();
        return this.base.getAndAdd(delta);
    }

    @Override
    public long getAndSet(long newValue) {
        this.ensure();
        return this.base.getAndSet(newValue);
    }

    @Override
    public long incrementAndGet() {
        this.ensure();
        return this.base.incrementAndGet();
    }

    @Override
    public void set(long newValue) {
        this.ensure();
        this.base.set(newValue);
    }

    @Override
    public AtomicNumberOperationsCounter getOperationsCounter() {
        this.ensure();
        return this.base.getOperationsCounter();
    }

    @Override
    public LocalAtomicNumberStats getLocalAtomicNumberStats() {
        this.ensure();
        return this.base.getLocalAtomicNumberStats();
    }

    @Override
    @Deprecated
    public void lazySet(long newValue) {
        this.set(newValue);
    }

    @Override
    @Deprecated
    public boolean weakCompareAndSet(long expect, long update) {
        return this.compareAndSet(expect, update);
    }

    private class AtomicNumberProxyReal
    implements AtomicNumberProxy {
        AtomicNumberOperationsCounter operationsCounter = new AtomicNumberOperationsCounter();

        @Override
        public String getName() {
            return AtomicNumberProxyImpl.this.name.substring("a:".length());
        }

        @Override
        public String getLongName() {
            return AtomicNumberProxyImpl.this.name;
        }

        @Override
        public Object getId() {
            return AtomicNumberProxyImpl.this.name;
        }

        @Override
        public long addAndGet(long delta) {
            return this.newMAtomicNumber().addAndGet(AtomicNumberProxyImpl.this.getNameAsData(), delta);
        }

        @Override
        public boolean compareAndSet(long expect, long update) {
            return this.newMAtomicNumber().compareAndSet(AtomicNumberProxyImpl.this.getNameAsData(), expect, update);
        }

        @Override
        public long decrementAndGet() {
            return this.addAndGet(-1L);
        }

        @Override
        public long get() {
            return this.addAndGet(0L);
        }

        @Override
        public long getAndAdd(long delta) {
            return this.newMAtomicNumber().getAndAdd(AtomicNumberProxyImpl.this.getNameAsData(), delta);
        }

        @Override
        public long getAndSet(long newValue) {
            return this.newMAtomicNumber().getAndSet(AtomicNumberProxyImpl.this.getNameAsData(), newValue);
        }

        @Override
        public long incrementAndGet() {
            return this.addAndGet(1L);
        }

        @Override
        public void set(long newValue) {
            this.getAndSet(newValue);
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.ATOMIC_NUMBER;
        }

        @Override
        public void destroy() {
            this.newMAtomicNumber().destroy(AtomicNumberProxyImpl.this.getNameAsData());
            AtomicNumberProxyImpl.this.factory.destroyInstanceClusterWide(AtomicNumberProxyImpl.this.name, null);
        }

        @Override
        public AtomicNumberOperationsCounter getOperationsCounter() {
            return this.operationsCounter;
        }

        @Override
        public LocalAtomicNumberStats getLocalAtomicNumberStats() {
            LocalAtomicNumberStatsImpl localAtomicStats = new LocalAtomicNumberStatsImpl();
            localAtomicStats.setOperationStats((LocalAtomicNumberOperationStats)this.operationsCounter.getPublishedStats());
            return localAtomicStats;
        }

        @Override
        @Deprecated
        public void lazySet(long newValue) {
            this.set(newValue);
        }

        @Override
        @Deprecated
        public boolean weakCompareAndSet(long expect, long update) {
            return this.compareAndSet(expect, update);
        }

        ConcurrentMapManager.MAtomicNumber newMAtomicNumber() {
            ConcurrentMapManager.MAtomicNumber mAtomicNumber = ((AtomicNumberProxyImpl)AtomicNumberProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MAtomicNumber();
            mAtomicNumber.setOperationsCounter(this.operationsCounter);
            return mAtomicNumber;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

