/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

public interface Instance {
    public InstanceType getInstanceType();

    public void destroy();

    public Object getId();

    public static enum InstanceType {
        QUEUE(1),
        MAP(2),
        SET(3),
        LIST(4),
        LOCK(5),
        TOPIC(6),
        MULTIMAP(7),
        ID_GENERATOR(8),
        ATOMIC_NUMBER(9),
        SEMAPHORE(10),
        COUNT_DOWN_LATCH(11);

        private final int typeId;

        private InstanceType(int typeId) {
            this.typeId = typeId;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public boolean isAtomicNumber() {
            return this.typeId == InstanceType.ATOMIC_NUMBER.typeId;
        }

        public boolean isCountDownLatch() {
            return this.typeId == InstanceType.COUNT_DOWN_LATCH.typeId;
        }

        public boolean isIdGenerator() {
            return this.typeId == InstanceType.ID_GENERATOR.typeId;
        }

        public boolean isList() {
            return this.typeId == InstanceType.LIST.typeId;
        }

        public boolean isLock() {
            return this.typeId == InstanceType.LOCK.typeId;
        }

        public boolean isMap() {
            return this.typeId == InstanceType.MAP.typeId;
        }

        public boolean isMultiMap() {
            return this.typeId == InstanceType.MULTIMAP.typeId;
        }

        public boolean isQueue() {
            return this.typeId == InstanceType.QUEUE.typeId;
        }

        public boolean isSemaphore() {
            return this.typeId == InstanceType.SEMAPHORE.typeId;
        }

        public boolean isSet() {
            return this.typeId == InstanceType.SET.typeId;
        }

        public boolean isTopic() {
            return this.typeId == InstanceType.TOPIC.typeId;
        }

        public static InstanceType valueOf(String string) {
            return Enum.valueOf(InstanceType.class, string);
        }
    }
}

