/*
 * Decompiled with CFR 0.152.
 */
package com.planetj.math.rabinhash;

import com.planetj.math.rabinhash.RabinHashFunction32;
import java.security.DigestException;
import java.security.MessageDigestSpi;

public final class RHF32
extends MessageDigestSpi
implements Cloneable {
    private final RabinHashFunction32 rhf = RabinHashFunction32.DEFAULT_HASH_FUNCTION;
    private int hash;

    protected int engineGetDigestLength() {
        return 4;
    }

    protected void engineUpdate(byte input) {
        this.hash = this.rhf.hash(new byte[]{input}, 0, 1, this.hash);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.hash = this.rhf.hash(input, offset, len, this.hash);
    }

    protected byte[] engineDigest() {
        byte[] buf = new byte[4];
        this.hashToBuf(buf, 0);
        this.engineReset();
        return buf;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 4) {
            throw new DigestException("Output buffer is smaller than digest length of 4");
        }
        this.hashToBuf(buf, offset);
        this.engineReset();
        return 4;
    }

    protected void engineReset() {
        this.hash = 0;
    }

    private void hashToBuf(byte[] buf, int offset) {
        buf[offset] = (byte)(this.hash >> 24);
        buf[offset + 1] = (byte)(this.hash >> 16);
        buf[offset + 2] = (byte)(this.hash >> 8);
        buf[offset + 3] = (byte)this.hash;
    }
}

