/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class DFA {
    private Graph aut;
    private int m;

    private static void preAut(char[] x, Graph aut) {
        int m = x.length;
        int state = Automata.getInitial(aut);
        for (int i = 0; i < m; ++i) {
            int oldTarget = Automata.getTarget(aut, state, x[i]);
            int target = Automata.newVertex(aut);
            Automata.setTarget(aut, state, x[i], target);
            Automata.copyVertex(aut, target, oldTarget);
            state = target;
        }
        Automata.setTerminal(aut, state);
    }

    public static List<Integer> findAll(String pattern, String source) {
        char[] x = pattern.toCharArray();
        char[] y = source.toCharArray();
        int m = x.length;
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        Graph aut = Automata.newAutomaton(m + 1, (m + 1) * 65536);
        DFA.preAut(x, aut);
        int state = Automata.getInitial(aut);
        for (int j = 0; j < n; ++j) {
            if (!Automata.isTerminal(aut, state = Automata.getTarget(aut, state, y[j]))) continue;
            result.add(j - m + 1);
        }
        return result;
    }

    public static DFA compile(String pattern) {
        char[] x = pattern.toCharArray();
        int m = x.length;
        Graph aut = Automata.newAutomaton(m + 1, (m + 1) * 65536);
        DFA.preAut(x, aut);
        DFA dfa = new DFA();
        dfa.aut = aut;
        dfa.m = m;
        return dfa;
    }

    public List<Integer> findAll(String source) {
        char[] y = source.toCharArray();
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int state = Automata.getInitial(this.aut);
        for (int j = 0; j < n; ++j) {
            if (!Automata.isTerminal(this.aut, state = Automata.getTarget(this.aut, state, y[j]))) continue;
            result.add(j - this.m + 1);
        }
        return result;
    }

    private static class Automata {
        private static final int UNDEFINED = -1;

        private Automata() {
        }

        public static Graph newGraph(int v, int e) {
            Graph g = new Graph();
            g.vertexNumber = v;
            g.edgeNumber = e;
            g.initial = 0;
            g.vertexCounter = 1;
            return g;
        }

        public static Graph newAutomaton(int v, int e) {
            Graph aut = Automata.newGraph(v, e);
            Graph.access$502(aut, new int[e]);
            Graph.access$602(aut, new int[v]);
            return aut;
        }

        public static Graph newSuffixAutomaton(int v, int e) {
            Graph aut = Automata.newAutomaton(v, e);
            Graph.access$502(aut, new int[e]);
            for (int i = 0; i < e; ++i) {
                ((Graph)aut).target[i] = -1;
            }
            Graph.access$702(aut, new int[v]);
            Graph.access$802(aut, new int[v]);
            Graph.access$902(aut, new int[v]);
            Graph.access$1002(aut, new int[e]);
            return aut;
        }

        public static Graph newTrie(int v, int e) {
            Graph aut = Automata.newAutomaton(v, e);
            Graph.access$502(aut, new int[e]);
            for (int i = 0; i < e; ++i) {
                ((Graph)aut).target[i] = -1;
            }
            Graph.access$702(aut, new int[v]);
            Graph.access$802(aut, new int[v]);
            Graph.access$902(aut, new int[v]);
            Graph.access$1002(aut, new int[e]);
            return aut;
        }

        public static int newVertex(Graph g) {
            int res = -1;
            if (g != null && g.vertexCounter <= g.vertexNumber) {
                res = g.vertexCounter++;
            }
            return res;
        }

        public static int getInitial(Graph g) {
            return g.initial;
        }

        public static boolean isTerminal(Graph g, int v) {
            boolean res = false;
            if (g != null && g.terminal != null && v < g.vertexNumber) {
                res = g.terminal[v] == 1;
            }
            return res;
        }

        public static void setTerminal(Graph g, int v) {
            if (g != null && g.terminal != null && v < g.vertexNumber) {
                ((Graph)g).terminal[v] = 1;
            }
        }

        public static int getTarget(Graph g, int v, int c) {
            int res = -1;
            if (g != null && g.target != null && v < g.vertexNumber && v * c < g.edgeNumber) {
                res = g.target[v * (g.edgeNumber / g.vertexNumber) + c];
            }
            return res;
        }

        public static void setTarget(Graph g, int v, int c, int t) {
            if (g != null && g.target != null && v < g.vertexNumber && v * c <= g.edgeNumber && t < g.vertexNumber) {
                ((Graph)g).target[v * (((Graph)g).edgeNumber / ((Graph)g).vertexNumber) + c] = t;
            }
        }

        public static int getSuffixLink(Graph g, int v) {
            int res = -1;
            if (g != null && g.suffixLink != null && v < g.vertexNumber) {
                res = g.suffixLink[v];
            }
            return res;
        }

        public static void setSuffixLink(Graph g, int v, int s) {
            if (g != null && g.suffixLink != null && v < g.vertexNumber && s < g.vertexNumber) {
                ((Graph)g).suffixLink[v] = s;
            }
        }

        public static int getLength(Graph g, int v) {
            int res = -1;
            if (g != null && g.length != null && v < g.vertexNumber) {
                res = g.length[v];
            }
            return res;
        }

        public static void setLength(Graph g, int v, int ell) {
            if (g != null && g.length != null && v < g.vertexNumber) {
                ((Graph)g).length[v] = ell;
            }
        }

        public static int getPosition(Graph g, int v) {
            int res = -1;
            if (g != null && g.position != null && v < g.vertexNumber) {
                res = g.position[v];
            }
            return res;
        }

        public static void setPosition(Graph g, int v, int p) {
            if (g != null && g.position != null && v < g.vertexNumber) {
                ((Graph)g).position[v] = p;
            }
        }

        public static int getShift(Graph g, int v, int c) {
            int res = -1;
            if (g != null && g.shift != null && v < g.vertexNumber && v * c < g.edgeNumber) {
                res = g.shift[v * (g.edgeNumber / g.vertexNumber) + c];
            }
            return res;
        }

        public static void setShift(Graph g, int v, int c, int s) {
            if (g != null && g.shift != null && v < g.vertexNumber && v * c <= g.edgeNumber) {
                ((Graph)g).shift[v * (((Graph)g).edgeNumber / ((Graph)g).vertexNumber) + c] = s;
            }
        }

        public static void copyVertex(Graph g, int target, int source) {
            if (g != null && target < g.vertexNumber && source < g.vertexNumber) {
                int i;
                if (g.target != null) {
                    for (i = 0; i < g.edgeNumber / g.vertexNumber; ++i) {
                        ((Graph)g).target[target * (((Graph)g).edgeNumber / ((Graph)g).vertexNumber) + i] = g.target[source * (g.edgeNumber / g.vertexNumber) + i];
                    }
                }
                if (g.shift != null) {
                    for (i = 0; i < g.edgeNumber / g.vertexNumber; ++i) {
                        ((Graph)g).shift[target * (((Graph)g).edgeNumber / ((Graph)g).vertexNumber) + i] = g.shift[source * (g.edgeNumber / g.vertexNumber) + i];
                    }
                }
                if (g.terminal != null) {
                    ((Graph)g).terminal[target] = g.terminal[source];
                }
                if (g.suffixLink != null) {
                    ((Graph)g).suffixLink[target] = g.suffixLink[source];
                }
                if (g.length != null) {
                    ((Graph)g).length[target] = g.length[source];
                }
                if (g.position != null) {
                    ((Graph)g).position[target] = g.position[source];
                }
            }
        }
    }

    private static class Graph {
        private int vertexNumber;
        private int edgeNumber;
        private int vertexCounter;
        private int initial;
        private int[] terminal;
        private int[] target;
        private int[] suffixLink;
        private int[] length;
        private int[] position;
        private int[] shift;

        private Graph() {
        }

        static /* synthetic */ int[] access$502(Graph x0, int[] x1) {
            x0.target = x1;
            return x1;
        }

        static /* synthetic */ int[] access$602(Graph x0, int[] x1) {
            x0.terminal = x1;
            return x1;
        }

        static /* synthetic */ int[] access$702(Graph x0, int[] x1) {
            x0.suffixLink = x1;
            return x1;
        }

        static /* synthetic */ int[] access$802(Graph x0, int[] x1) {
            x0.length = x1;
            return x1;
        }

        static /* synthetic */ int[] access$902(Graph x0, int[] x1) {
            x0.position = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1002(Graph x0, int[] x1) {
            x0.shift = x1;
            return x1;
        }
    }
}

