/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.openiconic.OpenIcon;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class PSystemOpenIconic
extends AbstractPSystem {
    private final String iconName;
    private final double factor;

    public PSystemOpenIconic(String string, double d) {
        this.iconName = string;
        this.factor = d;
    }

    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        OpenIcon openIcon = OpenIcon.retrieve(this.iconName);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(100.0, 100.0);
        UGraphic uGraphic = fileFormatOption.createUGraphic(dimension2DDouble);
        uGraphic = uGraphic.apply(new UTranslate(10.0, 10.0));
        openIcon.asTextBlock(HtmlColorUtils.BLACK, this.factor).drawU(uGraphic);
        uGraphic.writeImage(outputStream, null, 96);
        return new ImageDataSimple(dimension2DDouble);
    }

    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Open iconic)", this.getClass());
    }
}

