/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.json;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javasimon.console.json.AnyJS;
import org.javasimon.console.json.SimpleJS;
import org.javasimon.console.reflect.Getter;
import org.javasimon.console.reflect.GetterFactory;
import org.javasimon.console.text.Stringifier;
import org.javasimon.console.text.StringifierFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectJS
extends AnyJS {
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private Map<String, Attribute> attributesByName = new HashMap<String, Attribute>();

    public void setAttribute(String name, AnyJS value) {
        assert (name != null);
        assert (value != null);
        Attribute attribute = this.attributesByName.get(name);
        if (attribute == null) {
            attribute = new Attribute(name, value);
            this.attributes.add(attribute);
            this.attributesByName.put(name, attribute);
        } else {
            attribute.value = value;
        }
    }

    public <T> void setSimpleAttribute(String name, T value, Stringifier<T> stringifier) {
        SimpleJS<T> propertyJS = new SimpleJS<T>(value, stringifier);
        this.setAttribute(name, propertyJS);
    }

    public AnyJS getAttribute(String name) {
        assert (name != null);
        Attribute attribute = this.attributesByName.get(name);
        return attribute == null ? null : attribute.value;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write("{");
        boolean first = true;
        for (Attribute attribute : this.attributes) {
            if (first) {
                first = false;
            } else {
                writer.write(",");
            }
            this.writeString(writer, attribute.name);
            writer.write(":");
            attribute.value.write(writer);
        }
        writer.write("}");
    }

    public static ObjectJS create(Object o, StringifierFactory stringifierFactory) {
        if (o == null) {
            return null;
        }
        ObjectJS objectJS = new ObjectJS();
        for (Getter getter : GetterFactory.getGetters(o.getClass())) {
            String propertyName = getter.getName();
            Stringifier propertyStringifier = stringifierFactory.getStringifier(getter.getType(), getter.getSubType());
            if (propertyStringifier == null) continue;
            Object propertyValue = getter.get(o);
            objectJS.setSimpleAttribute(propertyName, propertyValue, propertyStringifier);
        }
        return objectJS;
    }

    private static class Attribute {
        private final String name;
        private AnyJS value;

        public Attribute(String name, AnyJS value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Attribute other = (Attribute)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            return this.name == null ? 0 : this.name.hashCode();
        }
    }
}

