/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletException;
import org.javasimon.Simon;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;
import org.javasimon.console.SimonType;
import org.javasimon.console.SimonVisitor;
import org.javasimon.console.SimonVisitors;
import org.javasimon.console.action.AbstractJsonAction;
import org.javasimon.console.json.ArrayJS;
import org.javasimon.console.json.ObjectJS;

public class ListJsonAction
extends AbstractJsonAction {
    public static final String PATH = "/data/list.json";
    private String pattern;
    private Set<SimonType> types;

    public ListJsonAction(ActionContext context) {
        super(context);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void readParameters() {
        super.readParameters();
        this.pattern = this.getContext().getParameterAsString("pattern", null);
        this.types = this.getContext().getParametersAsEnums("type", SimonType.class, null);
    }

    public void execute() throws ServletException, IOException, ActionException {
        this.getContext().setContentType("application/json");
        ArrayJS arrayJS = new ArrayJS();
        SimonVisitors.visitList(this.getContext().getManager(), this.pattern, this.types, new SimonVisitorImpl(arrayJS));
        arrayJS.write(this.getContext().getWriter());
    }

    private class SimonVisitorImpl
    implements SimonVisitor {
        private final ArrayJS arrayJS;

        public SimonVisitorImpl(ArrayJS arrayJS) {
            this.arrayJS = arrayJS;
        }

        public void visit(Simon simon) throws IOException {
            ObjectJS objectJS = ListJsonAction.this.createObjectJS(simon);
            this.arrayJS.addElement(objectJS);
        }
    }
}

