/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.git;

import com.openexchange.build.utils.Definitions;
import com.openexchange.git.VersionTag;
import com.openexchange.jgit.OXDescribeTagCommand;
import com.openexchange.jgit.TagDescription;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gradle.api.GradleException;

public class Git {
    private final Repository repository;
    private Map<ObjectId, Ref> tags = null;
    private final List<Ref> walkedTags = new ArrayList<Ref>();

    public Git(File gitDir) throws IOException {
        this.repository = this.initialize(gitDir);
        if (this.repository == null) {
            throw new GradleException("Did not find GIT directory");
        }
    }

    private Repository initialize(File gitDir) throws IOException {
        return ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir()).build();
    }

    private Map<ObjectId, Ref> readTags() throws IOException {
        if (null != this.tags) {
            return this.tags;
        }
        this.tags = new HashMap<ObjectId, Ref>();
        for (Ref r : this.repository.getRefDatabase().getRefs("refs/tags/").values()) {
            ObjectId key = this.repository.peel(r).getPeeledObjectId();
            if (key == null) {
                key = r.getObjectId();
            }
            this.tags.put(key, r);
        }
        return this.tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Ref> walkTags() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (!this.walkedTags.isEmpty()) {
            return this.walkedTags;
        }
        try (RevWalk walk = new RevWalk(this.repository);){
            walk.markStart(walk.parseCommit((AnyObjectId)this.repository.resolve("HEAD")));
            RevCommit candidate = null;
            Map<ObjectId, Ref> tags = this.readTags();
            while ((candidate = walk.next()) != null) {
                ObjectId candidateId = candidate.getId();
                Ref ref = tags.get(candidateId);
                if (null == ref) continue;
                this.walkedTags.add(ref);
            }
        }
        return this.walkedTags;
    }

    public List<String> getTags() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ArrayList<String> retval = new ArrayList<String>();
        for (Ref ref : this.walkTags()) {
            retval.add(ref.toString());
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VersionTag findHighestVersionTag() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        List<Ref> refs = this.walkTags();
        ArrayList<VersionTag> versions = new ArrayList<VersionTag>();
        try (RevWalk walk = new RevWalk(this.repository);){
            Iterator<Ref> i$ = refs.iterator();
            while (i$.hasNext()) {
                RevTag revTag;
                Matcher matcher;
                Ref ref = i$.next();
                RevObject object = walk.parseAny((AnyObjectId)ref.getObjectId());
                if (!(object instanceof RevTag) || !(matcher = Definitions.VERSION_AND_REVISION_PATTERN.matcher((revTag = (RevTag)object).getTagName())).matches()) continue;
                try {
                    versions.add(new VersionTag(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), revTag.getShortMessage(), revTag.getTaggerIdent().getName(), revTag.getTaggerIdent().getEmailAddress(), revTag.getTaggerIdent().getWhen()));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Unable to parse version tag: \"" + revTag.getTagName() + "\".", e);
                }
            }
            return (VersionTag)((Object)Collections.max(versions));
        }
    }

    public VersionTag getNewestVersionTag() throws GitAPIException, IOException {
        OXDescribeTagCommand odtc = new OXDescribeTagCommand(this.repository);
        TagDescription desc = odtc.call();
        if (desc == null) {
            throw new GradleException("Cannot find any version tag");
        }
        RevWalk walk = new RevWalk(this.repository);
        RevObject revObject = walk.parseAny((AnyObjectId)desc.getTagRef().getObjectId());
        RevTag revTag = (RevTag)revObject;
        Matcher matcher = Definitions.VERSION_AND_REVISION_PATTERN.matcher(revTag.getTagName());
        if (matcher.matches()) {
            try {
                VersionTag versionTag = new VersionTag(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), revTag.getShortMessage(), revTag.getTaggerIdent().getName(), revTag.getTaggerIdent().getEmailAddress(), revTag.getTaggerIdent().getWhen());
                versionTag.setCommitDistance(desc.getDistance());
                versionTag.setCommitId(desc.getCommit().getId().abbreviate(5).name());
                return versionTag;
            }
            catch (NumberFormatException e) {
                throw new IOException("Unable to parse version tag: \"" + revTag.getTagName() + "\".", e);
            }
        }
        throw new GradleException("Cannot find any version tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTag(String tag) throws IOException {
        Map tags = this.repository.getRefDatabase().getRefs("refs/tags/");
        Ref ref = (Ref)tags.get(tag);
        if (null == ref) {
            throw new GradleException("Can not find tag \"" + tag + "\"");
        }
        try (RevWalk walk = new RevWalk(this.repository);){
            RevTag revTag = walk.parseTag((AnyObjectId)ref.getObjectId());
            System.out.println(revTag.getFullMessage());
            System.out.println(revTag.getName());
            System.out.println(revTag.getShortMessage());
            System.out.println(revTag.getTagName());
            System.out.println(revTag.getTaggerIdent().getName());
            System.out.println(revTag.getTaggerIdent().getEmailAddress());
            System.out.println(revTag.getTaggerIdent().getTimeZone());
            System.out.println(revTag.getTaggerIdent().getWhen());
        }
    }
}

