/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa.pathfinder;

import java.util.Iterator;
import java.util.LinkedList;
import net.sourceforge.pmd.dfa.IDataFlowNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentPath {
    private LinkedList<IDataFlowNode> list = new LinkedList();

    public int getLength() {
        return this.list.size();
    }

    public Iterator<IDataFlowNode> iterator() {
        return this.list.iterator();
    }

    public IDataFlowNode getLast() {
        return this.list.getLast();
    }

    public void removeLast() {
        this.list.removeLast();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void addLast(IDataFlowNode n) {
        this.list.addLast(n);
    }

    public boolean isDoBranchNode() {
        return this.list.getLast().isType(41);
    }

    public boolean isFirstDoStatement() {
        return this.isFirstDoStatement(this.list.getLast());
    }

    public IDataFlowNode getDoBranchNodeFromFirstDoStatement() {
        IDataFlowNode inode = this.list.getLast();
        if (!this.isFirstDoStatement()) {
            return null;
        }
        for (IDataFlowNode iDataFlowNode : inode.getParents()) {
            if (!iDataFlowNode.isType(41)) continue;
            return iDataFlowNode;
        }
        return null;
    }

    public boolean isEndNode() {
        return this.list.getLast().getChildren().size() == 0;
    }

    public boolean isBranch() {
        return this.list.getLast().getChildren().size() > 1;
    }

    private boolean isFirstDoStatement(IDataFlowNode inode) {
        int index = inode.getIndex() - 1;
        if (index < 0) {
            return false;
        }
        return inode.getFlow().get(index).isType(40);
    }
}

