/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.batch;

import com.google.gdata.data.batch.IBatchInterrupted;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ServiceException;

public class BatchInterrupted
extends Element
implements IBatchInterrupted {
    public static final ElementKey<String, BatchInterrupted> KEY = ElementKey.of(new QName(Namespaces.batchNs, "interrupted"), String.class, BatchInterrupted.class);
    public static final AttributeKey<ContentType> CONTENT_TYPE = AttributeKey.of(new QName("content-type"), ContentType.class);
    public static final AttributeKey<Integer> ERROR_COUNT = AttributeKey.of(new QName("error"), Integer.class);
    public static final AttributeKey<String> REASON = AttributeKey.of(new QName("reason"));
    public static final AttributeKey<Integer> SKIPPED_COUNT = AttributeKey.of(new QName("unprocessed"), Integer.class);
    public static final AttributeKey<Integer> SUCCESS_COUNT = AttributeKey.of(new QName("success"), Integer.class);
    public static final AttributeKey<Integer> TOTAL_COUNT = AttributeKey.of(new QName("parsed"), Integer.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY).setContentRequired(false);
        builder.addAttribute(CONTENT_TYPE);
        builder.addAttribute(ERROR_COUNT).setRequired(true);
        builder.addAttribute(TOTAL_COUNT).setRequired(true);
        builder.addAttribute(REASON);
        builder.addAttribute(SUCCESS_COUNT).setRequired(true);
        builder.addAttribute(SKIPPED_COUNT).setRequired(true);
    }

    public BatchInterrupted() {
        super(KEY);
    }

    public BatchInterrupted(String reason, int totalCount, int successCount, int errorCount) {
        this();
        if (totalCount < successCount - errorCount) {
            throw new IllegalArgumentException("total < success + error. total = " + totalCount + " success=" + successCount + " error=" + errorCount);
        }
        this.setReason(reason);
        this.setTotalCount(totalCount);
        this.setSuccessCount(successCount);
        this.setErrorCount(errorCount);
        this.setSkippedCount(totalCount - (successCount + errorCount));
    }

    public BatchInterrupted(Throwable cause, int totalCount, int successCount, int errorCount) {
        this(BatchInterrupted.getReasonFromException(cause), totalCount, successCount, errorCount);
        if (cause instanceof ServiceException) {
            ServiceException se = (ServiceException)cause;
            this.setContent(se.getResponseBody());
            this.setContentType(se.getResponseContentType());
        }
    }

    public String getContent() {
        return this.getTextValue(KEY);
    }

    public BatchInterrupted setContent(String content) {
        this.setTextValue(content);
        return this;
    }

    public boolean hasContent() {
        return this.hasTextValue();
    }

    public ContentType getContentType() {
        return this.getAttributeValue(CONTENT_TYPE);
    }

    public BatchInterrupted setContentType(ContentType contentType) {
        this.setAttributeValue(CONTENT_TYPE, (Object)(contentType == null ? null : new ContentType(contentType.getMediaType())));
        return this;
    }

    public boolean hasContentType() {
        return this.getContentType() != null;
    }

    public int getErrorCount() {
        Integer count = this.getAttributeValue(ERROR_COUNT);
        return count == null ? 0 : count;
    }

    public BatchInterrupted setErrorCount(Integer errorCount) {
        this.setAttributeValue(ERROR_COUNT, (Object)errorCount);
        return this;
    }

    public boolean hasErrorCount() {
        return this.getErrorCount() != 0;
    }

    public String getReason() {
        return this.getAttributeValue(REASON);
    }

    public BatchInterrupted setReason(String reason) {
        this.setAttributeValue(REASON, (Object)reason);
        return this;
    }

    public boolean hasReason() {
        return this.getReason() != null;
    }

    public int getSkippedCount() {
        Integer count = this.getAttributeValue(SKIPPED_COUNT);
        return count == null ? 0 : count;
    }

    public BatchInterrupted setSkippedCount(Integer skippedCount) {
        this.setAttributeValue(SKIPPED_COUNT, (Object)skippedCount);
        return this;
    }

    public boolean hasSkippedCount() {
        return this.getSkippedCount() != 0;
    }

    public int getSuccessCount() {
        Integer count = this.getAttributeValue(SUCCESS_COUNT);
        return count == null ? 0 : count;
    }

    public BatchInterrupted setSuccessCount(Integer successCount) {
        this.setAttributeValue(SUCCESS_COUNT, (Object)successCount);
        return this;
    }

    public boolean hasSuccessCount() {
        return this.getSuccessCount() != 0;
    }

    public int getTotalCount() {
        Integer count = this.getAttributeValue(TOTAL_COUNT);
        return count == null ? 0 : count;
    }

    public BatchInterrupted setTotalCount(Integer totalCount) {
        this.setAttributeValue(TOTAL_COUNT, (Object)totalCount);
        return this;
    }

    public boolean hasTotalCount() {
        return this.getTotalCount() != 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        BatchInterrupted other = (BatchInterrupted)obj;
        return BatchInterrupted.eq(this.getContent(), other.getContent()) && BatchInterrupted.eq(this.getContentType(), other.getContentType()) && BatchInterrupted.eq(this.getErrorCount(), other.getErrorCount()) && BatchInterrupted.eq(this.getReason(), other.getReason()) && BatchInterrupted.eq(this.getSkippedCount(), other.getSkippedCount()) && BatchInterrupted.eq(this.getSuccessCount(), other.getSuccessCount()) && BatchInterrupted.eq(this.getTotalCount(), other.getTotalCount());
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.getContent() != null) {
            result = 37 * result + this.getContent().hashCode();
        }
        if (this.getContentType() != null) {
            result = 37 * result + this.getContentType().hashCode();
        }
        result = 37 * result + this.getErrorCount();
        if (this.getReason() != null) {
            result = 37 * result + this.getReason().hashCode();
        }
        result = 37 * result + this.getSkippedCount();
        result = 37 * result + this.getSuccessCount();
        result = 37 * result + this.getTotalCount();
        return result;
    }

    public String toString() {
        return "{BatchInterrupted content=" + this.getTextValue() + " contentType=" + this.getAttributeValue(CONTENT_TYPE) + " errorCount=" + this.getAttributeValue(ERROR_COUNT) + " reason=" + this.getAttributeValue(REASON) + " skippedCount=" + this.getAttributeValue(SKIPPED_COUNT) + " successCount=" + this.getAttributeValue(SUCCESS_COUNT) + " totalCount=" + this.getAttributeValue(TOTAL_COUNT) + "}";
    }

    private static String getReasonFromException(Throwable cause) {
        String message = cause.getMessage();
        if (message == null) {
            return "Unexpected error";
        }
        return message;
    }
}

