/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import org.xml.sax.Attributes;

public abstract class ValueConstruct
extends AbstractExtension {
    protected final String attrName;
    private String value;
    private boolean required = true;

    public final boolean isRequired() {
        return this.required;
    }

    protected final void setRequired(boolean isRequired) {
        this.required = isRequired;
    }

    protected ValueConstruct(String attrName) {
        this.attrName = attrName;
    }

    protected ValueConstruct(XmlNamespace namespace, String localName, String attrName) {
        this(namespace, localName, attrName, null);
    }

    protected ValueConstruct(XmlNamespace namespace, String localName, String attrName, String value) {
        super(namespace, localName);
        this.attrName = attrName;
        if (value != null) {
            this.setValue(value);
            this.setImmutable(true);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String v) {
        this.throwExceptionIfImmutable();
        this.value = v;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public void putAttributes(AttributeGenerator generator) {
        if (this.attrName != null) {
            generator.put(this.attrName, this.value);
        } else {
            generator.setContent(this.value);
        }
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        String actualValue = this.attrName != null ? helper.consume(this.attrName, this.isRequired()) : helper.consumeContent(this.isRequired());
        try {
            this.setValue(actualValue);
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException(iae.getMessage(), (Throwable)iae);
        }
    }

    public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
        if (this.value != null) {
            super.generate(w, p);
        }
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) throws ParseException {
        this.value = null;
        return super.getHandler(p, namespace, localName, attrs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        ValueConstruct vc = (ValueConstruct)o;
        return ValueConstruct.eq(this.value, vc.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }
}

