/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.piff;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class TfxdBox
extends AbstractFullBox {
    public long fragmentAbsoluteTime;
    public long fragmentAbsoluteDuration;

    public TfxdBox() {
        super("uuid");
    }

    public byte[] getUserType() {
        return new byte[]{109, 29, -101, 5, 66, -43, 68, -26, -128, -30, 20, 29, -81, -9, 87, -78};
    }

    protected long getContentSize() {
        return this.getVersion() == 1 ? 16L : 8L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        if (this.getVersion() == 1) {
            this.fragmentAbsoluteTime = in.readUInt64();
            this.fragmentAbsoluteDuration = in.readUInt64();
        } else {
            this.fragmentAbsoluteTime = in.readUInt32();
            this.fragmentAbsoluteDuration = in.readUInt32();
        }
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        if (this.getVersion() == 1) {
            os.writeUInt64(this.fragmentAbsoluteTime);
            os.writeUInt64(this.fragmentAbsoluteDuration);
        } else {
            os.writeUInt32(this.fragmentAbsoluteTime);
            os.writeUInt32(this.fragmentAbsoluteDuration);
        }
    }

    public long getFragmentAbsoluteTime() {
        return this.fragmentAbsoluteTime;
    }

    public long getFragmentAbsoluteDuration() {
        return this.fragmentAbsoluteDuration;
    }
}

