/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.util.Iterator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredSolrParams
extends SolrParams {
    protected final SolrParams params;

    public RequiredSolrParams(SolrParams params) {
        this.params = params;
    }

    @Override
    public String get(String param) {
        String val = this.params.get(param);
        if (val == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + param);
        }
        return val;
    }

    @Override
    public String getFieldParam(String field, String param) {
        String fpname = this.fpname(field, param);
        String val = this.params.get(fpname);
        if (null == val && null == (val = this.params.get(param))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + fpname + " (or default: " + param + ")");
        }
        return val;
    }

    @Override
    public String[] getFieldParams(String field, String param) {
        String fpname = this.fpname(field, param);
        String[] val = this.params.getParams(fpname);
        if (null == val && null == (val = this.params.getParams(param))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + fpname + " (or default: " + param + ")");
        }
        return val;
    }

    @Override
    public String[] getParams(String param) {
        String[] vals = this.params.getParams(param);
        if (vals == null || vals.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + param);
        }
        return vals;
    }

    @Override
    public Iterator<String> getParameterNamesIterator() {
        return this.params.getParameterNamesIterator();
    }

    public String toString() {
        return "{required(" + this.params + ")}";
    }

    @Override
    public String get(String param, String def) {
        return this.params.get(param, def);
    }

    @Override
    public int getInt(String param, int def) {
        return this.params.getInt(param, def);
    }

    @Override
    public float getFloat(String param, float def) {
        return this.params.getFloat(param, def);
    }

    @Override
    public boolean getBool(String param, boolean def) {
        return this.params.getBool(param, def);
    }

    @Override
    public int getFieldInt(String field, String param, int def) {
        return this.params.getFieldInt(field, param, def);
    }

    @Override
    public boolean getFieldBool(String field, String param, boolean def) {
        return this.params.getFieldBool(field, param, def);
    }

    @Override
    public float getFieldFloat(String field, String param, float def) {
        return this.params.getFieldFloat(field, param, def);
    }

    @Override
    public String getFieldParam(String field, String param, String def) {
        return this.params.getFieldParam(field, param, def);
    }
}

