/*
 * Copyright (c) 2008-2013, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.queue;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;

/**
 * User: ali
 * Date: 11/23/12
 * Time: 3:56 AM
 */
public final class PeekOperation extends QueueOperation implements IdentifiedDataSerializable {

    public PeekOperation() {
    }

    public PeekOperation(final String name) {
        super(name);
    }

    public void run() {
        QueueItem item = getOrCreateContainer().peek();
        response = item != null ? item.getData() : null;
    }

    public void afterRun() throws Exception {
        getQueueService().getLocalQueueStatsImpl(name).incrementOtherOperations();
    }

    public int getFactoryId() {
        return QueueDataSerializerHook.F_ID;
    }

    public int getId() {
        return QueueDataSerializerHook.PEEK;
    }
}
