/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples;

import org.javasimon.SimonManager;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.examples.ExampleUtils;
import org.javasimon.utils.BenchmarkUtils;
import org.javasimon.utils.GoogleChartImageGenerator;

public final class NanoMillisComparison {
    private static final int LOOP = 10000000;

    private NanoMillisComparison() {
    }

    public static void main(String[] args) {
        ExampleUtils.fillManagerWithSimons(100000);
        StopwatchSample[] results = BenchmarkUtils.run((int)2, (int)5, (BenchmarkUtils.Task[])new BenchmarkUtils.Task[]{new BenchmarkUtils.Task("empty"){

            public void perform() throws Exception {
                for (int i = 0; i < 10000000; ++i) {
                }
            }
        }, new BenchmarkUtils.Task("millis"){

            public void perform() throws Exception {
                for (int i = 0; i < 10000000; ++i) {
                    System.currentTimeMillis();
                }
            }
        }, new BenchmarkUtils.Task("nanos"){

            public void perform() throws Exception {
                for (int i = 0; i < 10000000; ++i) {
                    System.nanoTime();
                }
            }
        }, new BenchmarkUtils.Task("assign-ms"){

            public void perform() throws Exception {
                for (int i = 0; i < 10000000; ++i) {
                    long l = System.currentTimeMillis();
                }
            }
        }, new BenchmarkUtils.Task("assign-ns"){

            public void perform() throws Exception {
                for (int i = 0; i < 10000000; ++i) {
                    long l = System.nanoTime();
                }
            }
        }, new BenchmarkUtils.Task("just-start"){

            public void perform() throws Exception {
                Stopwatch simon = SimonManager.getStopwatch(null);
                for (int i = 0; i < 10000000; ++i) {
                    simon.start();
                }
            }
        }, new BenchmarkUtils.Task("start-stop"){

            public void perform() throws Exception {
                Stopwatch simon = SimonManager.getStopwatch(null);
                for (int i = 0; i < 10000000; ++i) {
                    simon.start().stop();
                }
            }
        }, new BenchmarkUtils.Task("get-start-stop"){

            public void perform() throws Exception {
                for (int i = 0; i < 10000000; ++i) {
                    SimonManager.getStopwatch((String)"some.name").start().stop();
                }
            }
        }});
        System.out.println("\nGoogle Chart avg:\n" + GoogleChartImageGenerator.barChart((StopwatchSample[])results, (String)"10M-loop duration", (double)1000000.0, (String)"ms", (boolean)false));
        System.out.println("\nGoogle Chart avg/max/min:\n" + GoogleChartImageGenerator.barChart((StopwatchSample[])results, (String)"10M-loop duration", (double)1000000.0, (String)"ms", (boolean)true));
    }
}

