/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.RemoteService;

public abstract class AbstractDistributedObject<S extends RemoteService>
implements DistributedObject {
    protected static final PartitioningStrategy PARTITIONING_STRATEGY = StringPartitioningStrategy.INSTANCE;
    private volatile NodeEngine nodeEngine;
    private volatile S service;

    protected AbstractDistributedObject(NodeEngine nodeEngine, S service) {
        this.nodeEngine = nodeEngine;
        this.service = service;
    }

    protected Data getNameAsPartitionAwareData() {
        String name = this.getName();
        return this.getNodeEngine().getSerializationService().toData(name, PARTITIONING_STRATEGY);
    }

    @Override
    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey(this.getName());
    }

    @Override
    public final void destroy() {
        NodeEngine engine = this.getNodeEngine();
        ProxyService proxyService = engine.getProxyService();
        proxyService.destroyDistributedObject(this.getServiceName(), this.getName());
        this.postDestroy();
    }

    protected void postDestroy() {
    }

    public final NodeEngine getNodeEngine() {
        NodeEngine engine = this.nodeEngine;
        this.lifecycleCheck(engine);
        return engine;
    }

    private void lifecycleCheck(NodeEngine engine) {
        if (engine == null || !engine.isActive()) {
            throw this.throwNotActiveException();
        }
    }

    protected RuntimeException throwNotActiveException() {
        throw new HazelcastInstanceNotActiveException();
    }

    public final S getService() {
        S s = this.service;
        if (s == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        return s;
    }

    @Override
    public abstract String getServiceName();

    final void invalidate() {
        this.nodeEngine = null;
        this.service = null;
    }

    @Override
    @Deprecated
    public final Object getId() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributedObject that = (DistributedObject)o;
        String name = this.getName();
        if (name != null ? !name.equals(that.getName()) : that.getName() != null) {
            return false;
        }
        String serviceName = this.getServiceName();
        return !(serviceName != null ? !serviceName.equals(that.getServiceName()) : that.getServiceName() != null);
    }

    public int hashCode() {
        int result = this.getServiceName() != null ? this.getServiceName().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        return result;
    }
}

