/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.obs.api;

import static com.openexchange.obs.api.Tools.transform;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * {@link BinaryParser}
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class BinaryParser {

    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private BinaryParser() {
        super();
    }

    public static Binary[] parse(final InputStream is) throws BuildServiceException {
        final Document document;
        try {
            final DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(is);
            final NodeList childs = document.getChildNodes();
            for (int i = 0; i < childs.getLength(); i++) {
                final Node node = childs.item(i);
                if ("binarylist".equals(node.getNodeName())) {
                    return parseBinaryList(node);
                } else if (Node.TEXT_NODE == node.getNodeType()) {
                    continue;
                } else {
                    throw new BuildServiceException("Unknown node in binary list \"" + node.getNodeName() + "\".");
                }
            }
        } catch (ParserConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        } catch (SAXException e) {
            throw new BuildServiceException(e.getMessage(), e);
        } catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        throw new BuildServiceException("Unable to parse project meta. " + transform(document));
    }

    private static Binary[] parseBinaryList(final Node binaryList) throws DOMException, BuildServiceException {
        final NodeList childs = binaryList.getChildNodes();
        final List<Binary> binaries = new ArrayList<Binary>();
        for (int i = 0; i < childs.getLength(); i++) {
            final Node node = childs.item(i);
            if ("binary".equals(node.getNodeName())) {
                binaries.add(parseBinary(node));
            } else if (Node.TEXT_NODE == node.getNodeType()) {
                continue;
            } else {
                throw new BuildServiceException("Unknown node in binary list \"" + node.getNodeName() + "\" \"" + node.getNodeValue() + "\".");
            }
        }
        return binaries.toArray(new Binary[binaries.size()]);
    }

    private static Binary parseBinary(Node binaryNode) {
        final NamedNodeMap attributes = binaryNode.getAttributes();
        final String filename = attributes.getNamedItem("filename").getNodeValue();
//        final String size = attributes.getNamedItem("size").getNodeValue();
//        final String mtime = attributes.getNamedItem("mtime").getNodeValue();
        final Binary binary = new Binary(filename);
        return binary;
    }
}
