/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.obs.api;

import java.util.ArrayList;
import java.util.List;

/**
 * Stores the actual result of a build.
 * <result project="open-xchange-7-test" repository="DebianSqueeze" arch="i586" state="building">
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class Result {

    @SuppressWarnings("unused")
    private final ProjectReference project;
    private final RepositoryReference repository;
    private final Architecture arch;
    private final State state;
    private final boolean dirty;
    private final List<PackageStatus> statuses = new ArrayList<PackageStatus>();

    public Result(final ProjectReference project, final RepositoryReference repository, final Architecture arch, final State state, boolean dirty) {
        super();
        this.project = project;
        this.repository = repository;
        this.arch = arch;
        this.state = state;
        this.dirty = dirty;
    }

    public RepositoryReference getRepository() {
        return repository;
    }

    public Architecture getArch() {
        return arch;
    }

    public void add(final PackageStatus status) {
        statuses.add(status);
    }

    public State getState() {
        return state;
    }

    public boolean isDirty() {
        return dirty;
    }

    public PackageStatus[] getStatuses() {
        return statuses.toArray(new PackageStatus[statuses.size()]);
    }

    @Override
    public String toString() {
        return getRepository().getName() + ':' + state.name() + ',' + statuses.size();
    }
}
