/*
 * Decompiled with CFR 0.152.
 */
package de.kippdata.cria.solrext.utils;

import de.kippdata.cria.solrext.utils.Token;
import de.kippdata.cria.solrext.utils.TokenTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormalFieldParser {
    private Map<String, List<String>> formalFieldMap;
    private static Logger log = Logger.getLogger(FormalFieldParser.class);

    public FormalFieldParser(Map<String, String> mapping) {
        this.formalFieldMap = this.createMapping(mapping);
    }

    public String parse(String source) {
        StringBuffer b = new StringBuffer();
        log.debug((Object)("[parse]: Parsing '" + source + "'"));
        List<Token> termList = this.split(source);
        for (Token t : termList) {
            String s = t.getTerm().split(":")[0];
            if (this.formalFieldMap.containsKey(s)) {
                b.append(this.parseTerm(t.getTerm(), this.formalFieldMap.get(s)) + " ");
                continue;
            }
            if (!(s.equalsIgnoreCase("AND") || s.equalsIgnoreCase("OR") || s.equalsIgnoreCase("NOT"))) {
                log.debug((Object)("[parse]: No mapping for field '" + s + "'"));
            }
            b.append(s + " ");
        }
        return b.toString().trim();
    }

    private List<Token> split(String source) {
        ArrayList<Token> termList = new ArrayList<Token>();
        boolean protectQuote = false;
        boolean escaped = false;
        StringBuilder b = new StringBuilder();
        log.trace((Object)("[split]: Starting to split '" + source + "'"));
        block7: for (char ch : source.toCharArray()) {
            log.trace((Object)("[split]: '" + ch + "'"));
            switch (ch) {
                case '\\': {
                    escaped = true;
                    log.trace((Object)"[split]: set escaped to TRUE");
                    b.append(ch);
                    continue block7;
                }
                case '\"': {
                    if (!escaped && !protectQuote) {
                        protectQuote = true;
                        log.trace((Object)"[split]: set protectQuote to TRUE");
                    } else if (!escaped && protectQuote) {
                        protectQuote = false;
                        log.trace((Object)"[split]: set protectQuote to FALSE");
                    }
                    if (escaped) {
                        escaped = false;
                        log.trace((Object)"[split]: set escape to FALSE");
                    }
                    b.append(ch);
                    continue block7;
                }
                case ' ': {
                    Token t;
                    if (!protectQuote) {
                        t = new Token(b.toString().trim(), TokenTypes.GENERIC);
                        termList.add(t);
                        log.debug((Object)("[split]: add term '" + t.getTerm() + "'"));
                        b.delete(0, b.length());
                        protectQuote = false;
                        escaped = false;
                        continue block7;
                    }
                    b.append(ch);
                    continue block7;
                }
                case '(': {
                    Token t;
                    if (!protectQuote) {
                        t = new Token(b.toString().trim(), TokenTypes.GENERIC);
                        if (b.toString().trim().length() > 0) {
                            termList.add(t);
                            log.debug((Object)("[split]: add term '" + t.getTerm() + "'"));
                        }
                        termList.add(new Token("(", TokenTypes.BRACKET));
                        log.debug((Object)"[split]: add term '('");
                        b.delete(0, b.length());
                        protectQuote = false;
                        escaped = false;
                        continue block7;
                    }
                    b.append(ch);
                    continue block7;
                }
                case ')': {
                    Token t;
                    if (!protectQuote) {
                        t = new Token(b.toString().trim(), TokenTypes.GENERIC);
                        if (b.toString().trim().length() > 0) {
                            termList.add(t);
                            log.debug((Object)("[split]: add term '" + t.getTerm() + "'"));
                        }
                        termList.add(new Token(")", TokenTypes.BRACKET));
                        log.debug((Object)"[split]: add term ')'");
                        b.delete(0, b.length());
                        protectQuote = false;
                        escaped = false;
                        continue block7;
                    }
                    b.append(ch);
                    continue block7;
                }
                default: {
                    b.append(ch);
                }
            }
        }
        Token t = new Token(b.toString().trim(), TokenTypes.GENERIC);
        termList.add(t);
        log.trace((Object)("[split]: add term '" + t.getTerm() + "'"));
        return termList;
    }

    private String parseTerm(String term, List<String> replacements) throws RuntimeException {
        log.debug((Object)("[parseTerm]: Receiving search string '" + term + "'"));
        if (!term.contains(":")) {
            throw new RuntimeException();
        }
        String searchTerm = term.substring(term.indexOf(":") + 1, term.length());
        StringBuffer b = new StringBuffer();
        b.append("(");
        for (String s : replacements) {
            b.append(s + ":" + searchTerm + " ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[parseTerm]: result is '" + b.toString().trim() + ")" + "'"));
        }
        return b.toString().trim() + ")";
    }

    private Map<String, List<String>> createMapping(Map<String, String> rawMap) {
        if (log.isTraceEnabled()) {
            for (String s : rawMap.keySet()) {
                log.debug((Object)("[createMapping]: Received " + s + ":" + rawMap.get(s)));
            }
        }
        HashMap<String, List<String>> fieldMappings = new HashMap<String, List<String>>();
        for (String formalField : rawMap.keySet()) {
            ArrayList<String> schemaFields = new ArrayList<String>();
            String mf = rawMap.get(formalField);
            if (mf.contains("{")) {
                String[] locales;
                log.trace((Object)"[createMapping]: is multi-field");
                String prefix = mf.substring(0, mf.indexOf("{"));
                for (String s : locales = mf.substring(mf.indexOf("{") + 1, mf.length() - 1).split(",")) {
                    schemaFields.add(prefix + "_" + s.trim());
                }
            } else {
                log.trace((Object)"[createMapping]: is standard field");
                schemaFields.add(mf);
            }
            fieldMappings.put(formalField, schemaFields);
        }
        if (log.isTraceEnabled()) {
            for (String s : fieldMappings.keySet()) {
                StringBuffer b = new StringBuffer();
                b.append(s + ":");
                for (String t : (List)fieldMappings.get(s)) {
                    b.append(t + " ");
                }
                log.trace((Object)("[createMapping]: result is " + b.toString()));
            }
        }
        return fieldMappings;
    }
}

