/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.contact.storage.rdb.mapping;

import com.openexchange.i18n.LocalizableStrings;


/**
 * {@link Strings}
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.com">Tobias Friedrich</a>
 */
public class Strings implements LocalizableStrings {

    public static final String DISPLAY_NAME = "Display name";
    public static final String DISPLAY_NAME_LIST = "Name";
    public static final String SUR_NAME = "Last name";
    public static final String GIVEN_NAME = "First name";
    public static final String MIDDLE_NAME = "Middle name";
    public static final String SUFFIX = "Suffix";
    public static final String TITLE = "Title";
    public static final String STREET_HOME = "Street (home)";
    public static final String POSTAL_CODE_HOME = "Postcode (home)";
    public static final String CITY_HOME = "Town (home)";
    public static final String STATE_HOME = "State (home)";
    public static final String COUNTRY_HOME = "Country (home)";
    public static final String MARITAL_STATUS = "Marital status";
    public static final String NUMBER_OF_CHILDREN = "Children";
    public static final String PROFESSION = "Profession";
    public static final String NICKNAME = "Nickname";
    public static final String SPOUSE_NAME = "Spouse's name";
    public static final String NOTE = "Comment";
    public static final String COMPANY = "Company";
    public static final String DEPARTMENT = "Department";
    public static final String POSITION = "Position";
    public static final String EMPLOYEE_TYPE = "Employee type";
    public static final String ROOM_NUMBER = "Room number";
    public static final String STREET_BUSINESS = "Street (business)";
    public static final String POSTAL_CODE_BUSINESS = "Postcode (business)";
    public static final String CITY_BUSINESS = "Town (business)";
    public static final String STATE_BUSINESS = "State (business)";
    public static final String COUNTRY_BUSINESS = "Country (business)";
    public static final String NUMBER_OF_EMPLOYEE = "Employee ID";
    public static final String SALES_VOLUME = "Sales volume";
    public static final String TAX_ID = "Tax id";
    public static final String COMMERCIAL_REGISTER = "Commercial register";
    public static final String BRANCHES = "Branches";
    public static final String BUSINESS_CATEGORY = "Business category";
    public static final String INFO = "Info";
    public static final String MANAGER_NAME = "Manager";
    public static final String ASSISTANT_NAME = "Assistant";
    public static final String STREET_OTHER = "Street (other)";
    public static final String POSTAL_CODE_OTHER = "Postcode (other)";
    public static final String CITY_OTHER = "Town (other)";
    public static final String STATE_OTHER = "State (other)";
    public static final String COUNTRY_OTHER = "Country (other)";
    public static final String TELEPHONE_ASSISTANT = "Telephone assistant";
    public static final String TELEPHONE_BUSINESS1 = "Phone (business)";
    public static final String TELEPHONE_BUSINESS2 = "Phone (business alt)";
    public static final String FAX_BUSINESS = "Fax";
    public static final String TELEPHONE_CALLBACK = "Telephone callback";
    public static final String TELEPHONE_CAR = "Phone (car)";
    public static final String TELEPHONE_COMPANY = "Telephone company";
    public static final String TELEPHONE_HOME1 = "Phone (home)";
    public static final String TELEPHONE_HOME2 = "Phone (home alt)";
    public static final String FAX_HOME = "FAX (home)";
    public static final String TELEPHONE_ISDN = "Telephone ISDN";
    public static final String CELLULAR_TELEPHONE1 = "Cell phone";
    public static final String CELLULAR_TELEPHONE2 = "Cell phone (alt)";
    public static final String TELEPHONE_OTHER = "Phone (other)";
    public static final String FAX_OTHER = "FAX other";
    public static final String TELEPHONE_PAGER = "Pager";
    public static final String TELEPHONE_PRIMARY = "Telephone primary";
    public static final String TELEPHONE_RADIO = "Telephone radio";
    public static final String TELEPHONE_TELEX = "Telex";
    public static final String TELEPHONE_TTYTDD = "TTY/TDD";
    public static final String INSTANT_MESSENGER1 = "Instant Messenger 1";
    public static final String INSTANT_MESSENGER2 = "Instant Messenger 2";
    public static final String TELEPHONE_IP = "IP phone";
    public static final String EMAIL1 = "Email 1";
    public static final String EMAIL2 = "Email 2";
    public static final String EMAIL3 = "Email 3";
    public static final String URL = "URL";
    public static final String CATEGORIES = "Categories";
    public static final String USERFIELD01 = "Optional 01";
    public static final String USERFIELD02 = "Optional 02";
    public static final String USERFIELD03 = "Optional 03";
    public static final String USERFIELD04 = "Optional 04";
    public static final String USERFIELD05 = "Optional 05";
    public static final String USERFIELD06 = "Optional 06";
    public static final String USERFIELD07 = "Optional 07";
    public static final String USERFIELD08 = "Optional 08";
    public static final String USERFIELD09 = "Optional 09";
    public static final String USERFIELD10 = "Optional 10";
    public static final String USERFIELD11 = "Optional 11";
    public static final String USERFIELD12 = "Optional 12";
    public static final String USERFIELD13 = "Optional 13";
    public static final String USERFIELD14 = "Optional 14";
    public static final String USERFIELD15 = "Optional 15";
    public static final String USERFIELD16 = "Optional 16";
    public static final String USERFIELD17 = "Optional 17";
    public static final String USERFIELD18 = "Optional 18";
    public static final String USERFIELD19 = "Optional 19";
    public static final String USERFIELD20 = "Optional 20";
    public static final String BIRTHDAY = "Date of birth";
    public static final String ANNIVERSARY = "Anniversary";
    public static final String FILE_AS = "File as";
    public static final String YOMI_FIRST_NAME = "First name (yomi)";
    public static final String YOMI_LAST_NAME = "Last name (yomi)";
    public static final String YOMI_COMPANY = "Company (yomi)";
    public static final String UID = "UID";
    public static final String FILENAME = "File name";
    public static final String HOME_ADDRESS = "Address (home)";
    public static final String BUSINESS_ADDRESS = "Address (business)";
    public static final String OTHER_ADDRESS = "Address (other)";


    /**
     * Initializes a new {@link Strings}.
     */
    private Strings() {
        super();
    }

}
