/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public final class SimpleFunctionalMapTest {
    private static final int ENTRY_COUNT = 1000;
    private static final int KB = 10240;
    private static final int STATS_SECONDS = 10;
    private static final Random RANDOM = new Random();

    private SimpleFunctionalMapTest() {
    }

    public static void main(String[] args) {
        int threadCount = 40;
        final Stats stats = new Stats();
        final HazelcastInstance hazelcast = Hazelcast.newHazelcastInstance(null);
        ExecutorService es = Executors.newFixedThreadPool(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    IMap<String, Object> map = hazelcast.getMap("default");
                    while (true) {
                        boolean i;
                        Collection col;
                        int keyInt = (int)(RANDOM.nextFloat() * 1000.0f);
                        int operation = (int)(RANDOM.nextFloat() * 1000.0f) % 20;
                        String key = String.valueOf(keyInt);
                        if (operation < 1) {
                            map.size();
                            stats.increment("size");
                            continue;
                        }
                        if (operation < 2) {
                            map.get(key);
                            stats.increment("get");
                            continue;
                        }
                        if (operation < 3) {
                            map.remove(key);
                            stats.increment("remove");
                            continue;
                        }
                        if (operation < 4) {
                            map.containsKey(key);
                            stats.increment("containsKey");
                            continue;
                        }
                        if (operation < 5) {
                            String value = String.valueOf(key);
                            map.containsValue(value);
                            stats.increment("containsValue");
                            continue;
                        }
                        if (operation < 6) {
                            map.putIfAbsent(key, SimpleFunctionalMapTest.createValue());
                            stats.increment("putIfAbsent");
                            continue;
                        }
                        if (operation < 7) {
                            col = map.values();
                            for (Object o : col) {
                                i = false;
                            }
                            stats.increment("values");
                            continue;
                        }
                        if (operation < 8) {
                            col = map.keySet();
                            for (Object o : col) {
                                i = false;
                            }
                            stats.increment("keySet");
                            continue;
                        }
                        if (operation < 9) {
                            col = map.entrySet();
                            for (Object o : col) {
                                i = false;
                            }
                            stats.increment("entrySet");
                            continue;
                        }
                        map.put(key, SimpleFunctionalMapTest.createValue());
                        stats.increment("put");
                    }
                }
            });
        }
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(10000L);
                            System.out.println("cluster size:" + hazelcast.getCluster().getMembers().size());
                            Stats currentStats = stats.getAndReset();
                            System.out.println(currentStats);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public static Object createValue() {
        int numberOfK = (int)(RANDOM.nextFloat() * 1000.0f) % 40 + 1;
        return new byte[numberOfK * 10240];
    }

    public static class Stats {
        Map<String, AtomicLong> mapStats = new ConcurrentHashMap<String, AtomicLong>(10);

        public Stats() {
            this.mapStats.put("put", new AtomicLong(0L));
            this.mapStats.put("get", new AtomicLong(0L));
            this.mapStats.put("remove", new AtomicLong(0L));
            this.mapStats.put("size", new AtomicLong(0L));
            this.mapStats.put("containsKey", new AtomicLong(0L));
            this.mapStats.put("containsValue", new AtomicLong(0L));
            this.mapStats.put("clear", new AtomicLong(0L));
            this.mapStats.put("keySet", new AtomicLong(0L));
            this.mapStats.put("values", new AtomicLong(0L));
            this.mapStats.put("entrySet", new AtomicLong(0L));
            this.mapStats.put("putIfAbsent", new AtomicLong(0L));
        }

        public Stats getAndReset() {
            Stats newOne = new Stats();
            Set<Map.Entry<String, AtomicLong>> entries = newOne.mapStats.entrySet();
            for (Map.Entry<String, AtomicLong> entry : entries) {
                String key = entry.getKey();
                AtomicLong value = entry.getValue();
                value.set(this.mapStats.get(key).getAndSet(0L));
            }
            return newOne;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            long total = 0L;
            Set<Map.Entry<String, AtomicLong>> entries = this.mapStats.entrySet();
            for (Map.Entry<String, AtomicLong> entry : entries) {
                String key = entry.getKey();
                AtomicLong value = entry.getValue();
                sb.append(key + ":" + value.get());
                sb.append("\n");
                total += value.get();
            }
            sb.append("Operations per Second : " + total / 10L + " \n");
            return sb.toString();
        }

        public void increment(String operation) {
            this.mapStats.get(operation).incrementAndGet();
        }
    }
}

