/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.quantiles;

import java.util.Properties;
import org.javasimon.Simon;
import org.javasimon.Stopwatch;
import org.javasimon.callback.quantiles.Buckets;
import org.javasimon.callback.quantiles.QuantilesCallback;

public class PropertiesQuantilesCallback
extends QuantilesCallback {
    private final Properties properties;

    public PropertiesQuantilesCallback(Properties properties) {
        this.properties = properties;
    }

    protected Buckets createBuckets(Stopwatch stopwatch) {
        Long min = this.getLongProperty(stopwatch, "min") * 1000000L;
        Long max = this.getLongProperty(stopwatch, "max") * 1000000L;
        Integer nb = this.getIntegerProperty(stopwatch, "nb");
        return this.createBuckets(stopwatch, min, max, nb);
    }

    private String getProperty(Simon simon, String name) {
        return this.properties.getProperty(simon.getName() + "." + name);
    }

    private static String toString(String s) {
        if (s != null && (s = s.trim()).equals("")) {
            s = null;
        }
        return s;
    }

    private static Long toLong(String s) {
        s = PropertiesQuantilesCallback.toString(s);
        Long l = null;
        if (s != null) {
            try {
                l = Long.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                l = null;
            }
        }
        return l;
    }

    private Long getLongProperty(Simon simon, String name) {
        Simon currentSimon = simon;
        Long l = null;
        while (l == null && currentSimon != null) {
            l = PropertiesQuantilesCallback.toLong(this.getProperty(currentSimon, name));
            currentSimon = simon.getParent();
        }
        return l;
    }

    private static Integer toInteger(String s) {
        s = PropertiesQuantilesCallback.toString(s);
        Integer i = null;
        if (s != null) {
            try {
                i = Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                i = null;
            }
        }
        return i;
    }

    private Integer getIntegerProperty(Simon simon, String name) {
        Simon currentSimon = simon;
        Integer l = null;
        while (l == null && currentSimon != null) {
            l = PropertiesQuantilesCallback.toInteger(this.getProperty(currentSimon, name));
            currentSimon = simon.getParent();
        }
        return l;
    }
}

