/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.util.ThreadWatcher;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class InOutSelector
implements Runnable {
    protected final ILogger logger;
    protected final Selector selector;
    protected final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final ConnectionManager connectionManager;
    private final int waitTime;
    protected boolean live = true;
    protected final ThreadWatcher threadWatcher = new ThreadWatcher();
    static final long TEN_SECOND_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private long lastPublish = 0L;

    public InOutSelector(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.logger = connectionManager.ioService.getLogger(this.getClass().getName());
        this.waitTime = 500;
        Selector selectorTemp = null;
        try {
            selectorTemp = Selector.open();
        }
        catch (IOException e) {
            this.handleSelectorException(e);
        }
        this.selector = selectorTemp;
        this.live = true;
    }

    public void shutdown() {
        this.selectorQueue.clear();
        try {
            final CountDownLatch l = new CountDownLatch(1);
            this.addTask(new Runnable(){

                @Override
                public void run() {
                    InOutSelector.this.live = false;
                    InOutSelector.this.threadLocalShutdown();
                    l.countDown();
                }
            });
            l.await(5L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void threadLocalShutdown() {
    }

    public void addTask(Runnable runnable) {
        this.selectorQueue.offer(runnable);
    }

    private void processSelectionQueue() {
        while (this.live) {
            Runnable runnable = this.selectorQueue.poll();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
    }

    public void publishUtilization() {
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleSelectorException(Throwable e) {
        String msg = "Selector exception at  " + Thread.currentThread().getName() + ", cause= " + e.toString();
        this.logger.log(Level.WARNING, msg, e);
        if (e instanceof OutOfMemoryError) {
            this.connectionManager.ioService.onOutOfMemory((OutOfMemoryError)e);
        }
    }
}

