/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.netcdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public class NetCDFParser
extends AbstractParser {
    private static final long serialVersionUID = -5940938274907708665L;
    private final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("x-netcdf"));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy(stream, (OutputStream)os);
        String name = metadata.get("resourceName");
        if (name == null) {
            name = "";
        }
        try {
            NetcdfFile ncFile = NetcdfFile.openInMemory(name, os.toByteArray());
            for (Attribute attr : ncFile.getGlobalAttributes()) {
                Property property = this.resolveMetadataKey(attr.getName());
                if (attr.getDataType().isString()) {
                    metadata.add(property, attr.getStringValue());
                    continue;
                }
                if (!attr.getDataType().isNumeric()) continue;
                int value = attr.getNumericValue().intValue();
                metadata.add(property, String.valueOf(value));
            }
        }
        catch (IOException e) {
            throw new TikaException("NetCDF parse error", e);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    private Property resolveMetadataKey(String localName) {
        if ("title".equals(localName)) {
            return TikaCoreProperties.TITLE;
        }
        return Property.internalText(localName);
    }
}

